/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.data;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.texture.SpriteContentsExtended;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_854;

public class ChunkRenderData {
    public static final ChunkRenderData ABSENT = new Builder().build();
    public static final ChunkRenderData EMPTY = ChunkRenderData.createEmptyData();
    private List<TerrainRenderPass> blockRenderPasses;
    private List<class_2586> globalBlockEntities;
    private List<class_2586> blockEntities;
    private class_854 occlusionData;
    private ChunkRenderBounds bounds;
    private List<class_1058> animatedSprites;

    public ChunkRenderBounds getBounds() {
        return this.bounds;
    }

    public class_854 getOcclusionData() {
        return this.occlusionData;
    }

    public List<class_1058> getAnimatedSprites() {
        return this.animatedSprites;
    }

    public Collection<class_2586> getBlockEntities() {
        return this.blockEntities;
    }

    public Collection<class_2586> getGlobalBlockEntities() {
        return this.globalBlockEntities;
    }

    public int getFlags() {
        int flags = 0;
        if (!this.blockRenderPasses.isEmpty()) {
            flags |= 1;
        }
        if (!this.blockEntities.isEmpty() || !this.globalBlockEntities.isEmpty()) {
            flags |= 2;
        }
        return flags;
    }

    private static ChunkRenderData createEmptyData() {
        class_854 occlusionData = new class_854();
        occlusionData.method_3693(EnumSet.allOf(class_2350.class));
        Builder meshInfo = new Builder();
        meshInfo.setOcclusionData(occlusionData);
        return meshInfo.build();
    }

    public static class Builder {
        private final List<TerrainRenderPass> renderPasses = new ArrayList<TerrainRenderPass>();
        private final List<class_2586> globalBlockEntities = new ArrayList<class_2586>();
        private final List<class_2586> blockEntities = new ArrayList<class_2586>();
        private final Set<class_1058> animatedSprites = new ObjectOpenHashSet();
        private class_854 occlusionData;
        private ChunkRenderBounds bounds = ChunkRenderBounds.ALWAYS_FALSE;

        public void addRenderPass(TerrainRenderPass pass) {
            this.renderPasses.add(pass);
        }

        public void setBounds(ChunkRenderBounds bounds) {
            this.bounds = bounds;
        }

        public void setOcclusionData(class_854 data) {
            this.occlusionData = data;
        }

        public void addSprite(class_1058 sprite) {
            if (((SpriteContentsExtended)sprite.method_45851()).hasAnimation()) {
                this.animatedSprites.add(sprite);
            }
        }

        public void addBlockEntity(class_2586 entity, boolean cull) {
            (cull ? this.blockEntities : this.globalBlockEntities).add(entity);
        }

        public ChunkRenderData build() {
            ChunkRenderData data = new ChunkRenderData();
            data.globalBlockEntities = this.globalBlockEntities;
            data.blockEntities = this.blockEntities;
            data.occlusionData = this.occlusionData;
            data.bounds = this.bounds;
            data.animatedSprites = new ObjectArrayList(this.animatedSprites);
            data.blockRenderPasses = this.renderPasses;
            return data;
        }
    }
}

