/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.region;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.arena.PendingUpload;
import me.jellysquid.mods.sodium.client.gl.arena.staging.FallbackStagingBuffer;
import me.jellysquid.mods.sodium.client.gl.arena.staging.MappedStagingBuffer;
import me.jellysquid.mods.sodium.client.gl.arena.staging.StagingBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;

public class RenderRegionManager {
    private final Long2ReferenceOpenHashMap<RenderRegion> regions = new Long2ReferenceOpenHashMap();
    private final StagingBuffer stagingBuffer;

    public RenderRegionManager(CommandList commandList) {
        this.stagingBuffer = RenderRegionManager.createStagingBuffer(commandList);
    }

    public void cleanup() {
        this.stagingBuffer.flip();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            ObjectIterator it = this.regions.values().iterator();
            while (it.hasNext()) {
                RenderRegion region = (RenderRegion)it.next();
                if (!region.isEmpty()) continue;
                region.delete(commandList);
                it.remove();
            }
        }
    }

    public void upload(CommandList commandList, Iterator<ChunkBuildResult> queue) {
        for (Map.Entry<RenderRegion, List<ChunkBuildResult>> entry : this.setupUploadBatches(commandList, queue).entrySet()) {
            RenderRegion region = entry.getKey();
            List<ChunkBuildResult> uploadQueue = entry.getValue();
            this.upload(commandList, region, uploadQueue);
            for (ChunkBuildResult result : uploadQueue) {
                result.render.onBuildFinished(result);
                result.delete();
            }
        }
    }

    private void upload(CommandList commandList, RenderRegion region, List<ChunkBuildResult> results) {
        ArrayList<PendingSectionUpload> sectionUploads = new ArrayList<PendingSectionUpload>();
        for (ChunkBuildResult result : results) {
            for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
                ChunkMeshData meshData;
                ChunkGraphicsState graphics;
                RenderRegion.RenderRegionStorage storage = region.getStorage(pass);
                if (storage != null && (graphics = storage.setState(result.render, null)) != null) {
                    graphics.delete();
                }
                if ((meshData = result.getMesh(pass)) == null) continue;
                sectionUploads.add(new PendingSectionUpload(result.render, meshData, pass, new PendingUpload(meshData.getVertexData())));
            }
        }
        if (sectionUploads.isEmpty()) {
            return;
        }
        boolean bufferChanged = region.vertexBuffers.upload(commandList, sectionUploads.stream().map(i -> i.vertexUpload));
        if (bufferChanged) {
            region.deleteTessellations(commandList);
        }
        for (PendingSectionUpload upload : sectionUploads) {
            region.createStorage(upload.pass).replaceState(upload.section, new ChunkGraphicsState(upload.vertexUpload.getResult(), upload.meshData));
        }
    }

    private Map<RenderRegion, List<ChunkBuildResult>> setupUploadBatches(CommandList commandList, Iterator<ChunkBuildResult> renders) {
        Reference2ObjectLinkedOpenHashMap map = new Reference2ObjectLinkedOpenHashMap();
        while (renders.hasNext()) {
            ChunkBuildResult result;
            RenderSection render = result.render;
            result = renders.next();
            if (!render.canAcceptBuildResults(result)) {
                result.delete();
                continue;
            }
            RenderRegion region = this.prepareRegionForChunk(commandList, render.getChunkX(), render.getChunkY(), render.getChunkZ());
            List uploadQueue = map.computeIfAbsent(region, k -> new ArrayList());
            uploadQueue.add(result);
        }
        return map;
    }

    public RenderRegion prepareRegionForChunk(CommandList commandList, int x, int y, int z) {
        long key = RenderRegion.getRegionKeyForChunk(x, y, z);
        RenderRegion region = (RenderRegion)this.regions.get(key);
        if (region == null) {
            region = RenderRegion.createRegionForChunk(commandList, this.stagingBuffer, x, y, z);
            this.regions.put(key, (Object)region);
        }
        return region;
    }

    public void delete(CommandList commandList) {
        for (RenderRegion region : this.regions.values()) {
            region.delete(commandList);
        }
        this.regions.clear();
        this.stagingBuffer.delete(commandList);
    }

    public Collection<RenderRegion> getLoadedRegions() {
        return this.regions.values();
    }

    public StagingBuffer getStagingBuffer() {
        return this.stagingBuffer;
    }

    private static StagingBuffer createStagingBuffer(CommandList commandList) {
        if (SodiumClientMod.options().advanced.useAdvancedStagingBuffers && MappedStagingBuffer.isSupported(RenderDevice.INSTANCE)) {
            return new MappedStagingBuffer(commandList);
        }
        return new FallbackStagingBuffer(commandList);
    }

    public RenderRegion getRegion(long longKey) {
        return (RenderRegion)this.regions.get(longKey);
    }

    private record PendingSectionUpload(RenderSection section, ChunkMeshData meshData, TerrainRenderPass pass, PendingUpload vertexUpload) {
    }
}

