/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.immediate.model;

import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.minecraft.class_2350;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class ModelCuboid {
    public final Quad[] quads;
    private final Vector3f[] vertices;
    private final Vector3f[] shared;

    public ModelCuboid(int u, int v, float x1, float y1, float z1, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirror, float textureWidth, float textureHeight) {
        float x2 = x1 + sizeX;
        float y2 = y1 + sizeY;
        float z2 = z1 + sizeZ;
        x1 -= extraX;
        y1 -= extraY;
        z1 -= extraZ;
        x2 += extraX;
        y2 += extraY;
        z2 += extraZ;
        if (mirror) {
            float i = x2;
            x2 = x1;
            x1 = i;
        }
        Vector3f[] vertices = new Vector3f[]{new Vector3f(x1, y1, z1), new Vector3f(x2, y1, z1), new Vector3f(x2, y2, z1), new Vector3f(x1, y2, z1), new Vector3f(x1, y1, z2), new Vector3f(x2, y1, z2), new Vector3f(x2, y2, z2), new Vector3f(x1, y2, z2)};
        Vector3f[] shared = new Vector3f[8];
        for (int i = 0; i < 8; ++i) {
            vertices[i].div(16.0f);
            shared[i] = new Vector3f(Float.NaN);
        }
        float u0 = u;
        float u1 = (float)u + sizeZ;
        float u2 = (float)u + sizeZ + sizeX;
        float u3 = (float)u + sizeZ + sizeX + sizeX;
        float u4 = (float)u + sizeZ + sizeX + sizeZ;
        float u5 = (float)u + sizeZ + sizeX + sizeZ + sizeX;
        float v0 = v;
        float v1 = (float)v + sizeZ;
        float v2 = (float)v + sizeZ + sizeY;
        Quad[] sides = new Quad[6];
        sides[2] = new Quad(new Vector3f[]{shared[5], shared[4], shared[0], shared[1]}, u1, v0, u2, v1, textureWidth, textureHeight, mirror, class_2350.field_11033);
        sides[3] = new Quad(new Vector3f[]{shared[2], shared[3], shared[7], shared[6]}, u2, v1, u3, v0, textureWidth, textureHeight, mirror, class_2350.field_11036);
        sides[1] = new Quad(new Vector3f[]{shared[0], shared[4], shared[7], shared[3]}, u0, v1, u1, v2, textureWidth, textureHeight, mirror, class_2350.field_11039);
        sides[4] = new Quad(new Vector3f[]{shared[1], shared[0], shared[3], shared[2]}, u1, v1, u2, v2, textureWidth, textureHeight, mirror, class_2350.field_11043);
        sides[0] = new Quad(new Vector3f[]{shared[5], shared[1], shared[2], shared[6]}, u2, v1, u4, v2, textureWidth, textureHeight, mirror, class_2350.field_11034);
        sides[5] = new Quad(new Vector3f[]{shared[4], shared[5], shared[6], shared[7]}, u4, v1, u5, v2, textureWidth, textureHeight, mirror, class_2350.field_11035);
        this.quads = sides;
        this.vertices = vertices;
        this.shared = shared;
    }

    public void updateVertices(Matrix4f mat) {
        for (int i = 0; i < 8; ++i) {
            Vector3f src = this.vertices[i];
            Vector3f dst = this.shared[i];
            src.mulPosition((Matrix4fc)mat, dst);
        }
    }

    public static class Quad {
        public final Vector3f[] positions;
        public final Vector2f[] textures;
        public final Vector3f direction;

        public Quad(Vector3f[] positions, float u1, float v1, float u2, float v2, float textureWidth, float textureHeight, boolean flip, class_2350 direction) {
            Vector2f[] textures = new Vector2f[]{new Vector2f(u2 / textureWidth, v1 / textureHeight), new Vector2f(u1 / textureWidth, v1 / textureHeight), new Vector2f(u1 / textureWidth, v2 / textureHeight), new Vector2f(u2 / textureWidth, v2 / textureHeight)};
            if (flip) {
                int len = positions.length;
                for (int i = 0; i < len / 2; ++i) {
                    Vector3f pos = positions[i];
                    positions[i] = positions[len - 1 - i];
                    positions[len - 1 - i] = pos;
                    Vector2f tex = textures[i];
                    textures[i] = textures[len - 1 - i];
                    textures[len - 1 - i] = tex;
                }
            }
            this.positions = positions;
            this.textures = textures;
            this.direction = direction.method_23955();
            if (flip) {
                this.direction.mul(-1.0f, 1.0f, 1.0f);
            }
        }

        public int getNormal(Matrix3f mat) {
            return MatrixHelper.transformNormal(mat, this.direction.x, this.direction.y, this.direction.z);
        }
    }
}

