/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.vertex;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import net.caffeinemc.mods.sodium.api.vertex.attributes.CommonVertexAttribute;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.minecraft.class_293;
import net.minecraft.class_296;

public class VertexFormatDescriptionImpl
implements VertexFormatDescription {
    private final int id;
    private final int stride;
    private final int[] offsets;

    public VertexFormatDescriptionImpl(class_293 format, int id) {
        this.id = id;
        this.stride = format.method_1362();
        this.offsets = VertexFormatDescriptionImpl.getOffsets(format);
    }

    public static int[] getOffsets(class_293 format) {
        int[] offsets = new int[CommonVertexAttribute.COUNT];
        Arrays.fill(offsets, -1);
        ImmutableList elements = format.method_1357();
        for (int elementIndex = 0; elementIndex < elements.size(); ++elementIndex) {
            class_296 element = (class_296)elements.get(elementIndex);
            CommonVertexAttribute commonType = CommonVertexAttribute.getCommonType(element);
            if (commonType == null) continue;
            offsets[commonType.ordinal()] = format.field_1597.getInt(elementIndex);
        }
        return offsets;
    }

    @Override
    public boolean containsElement(CommonVertexAttribute element) {
        return this.offsets[element.ordinal()] != -1;
    }

    @Override
    public int getElementOffset(CommonVertexAttribute element) {
        int offset = this.offsets[element.ordinal()];
        if (offset == -1) {
            throw new NoSuchElementException("Vertex format does not contain element: " + element);
        }
        return offset;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int stride() {
        return this.stride;
    }
}

