/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.color;

import net.minecraft.class_1011;

public class ColorSRGB {
    private static final int[] TO_SRGB8_TABLE = new int[]{7536653, 7995405, 0x80000D, 8847373, 0x8D000D, 9699341, 10092557, 10551309, 10944538, 11796506, 12648474, 13500442, 14286874, 15138842, 15990810, 0x101001A, 17694771, 19398707, 21037107, 22741043, 24444979, 26148915, 27787315, 29491251, 31195239, 34537575, 37945447, 41287783, 44695655, 48037991, 51445863, 54788199, 58196174, 64946382, 71696590, 78446798, 85197006, 91947205, 98369724, 104530101, 110559576, 121766210, 132317488, 142278944, 151716114, 160694534, 169279740, 177537266, 185532875, 200540590, 214630805, 227869056, 240517486, 252510558, 263979344, 274923843, 285672036, 305660478, 324469277, 342229505, 359006697, 374997459, 390332864, 405012911, 419300145, 446038782, 471139026, 494797485, 517210765, 538575472, 559022678, 578617920, 597623875, 633340926, 666829764, 698418066, 728367975, 756876097, 784204575, 810353408, 835782064, 883426645, 928122119, 970261701, 1010238603, 1048314968, 1084752938, 1119683585, 1153566616, 1217267486, 1276905142, 1333134941, 1386546704, 1437337036, 1485964687, 1532560729, 1577847331, 1662781824, 1742407926, 1817512063, 1888749592, 1956644797, 2021459820, 2083718947};
    private static final float[] FROM_SRGB8_TABLE = new float[]{0.0f, 3.03527E-4f, 6.07054E-4f, 9.1058103E-4f, 0.001214108f, 0.001517635f, 0.0018211621f, 0.002124689f, 0.002428216f, 0.002731743f, 0.00303527f, 0.0033465356f, 0.003676507f, 0.004024717f, 0.004391442f, 0.0047769533f, 0.005181517f, 0.0056053917f, 0.0060488326f, 0.006512091f, 0.00699541f, 0.0074990317f, 0.008023192f, 0.008568125f, 0.009134057f, 0.009721218f, 0.010329823f, 0.010960094f, 0.011612245f, 0.012286487f, 0.012983031f, 0.013702081f, 0.014443844f, 0.015208514f, 0.015996292f, 0.016807375f, 0.017641952f, 0.018500218f, 0.019382361f, 0.020288562f, 0.02121901f, 0.022173883f, 0.023153365f, 0.02415763f, 0.025186857f, 0.026241222f, 0.027320892f, 0.028426038f, 0.029556843f, 0.03071345f, 0.03189604f, 0.033104774f, 0.03433981f, 0.035601325f, 0.036889452f, 0.038204376f, 0.039546248f, 0.04091521f, 0.042311423f, 0.043735042f, 0.045186214f, 0.046665095f, 0.048171833f, 0.049706575f, 0.051269468f, 0.052860655f, 0.05448028f, 0.056128494f, 0.057805434f, 0.05951124f, 0.06124607f, 0.06301003f, 0.06480328f, 0.06662595f, 0.06847818f, 0.07036011f, 0.07227186f, 0.07421358f, 0.07618539f, 0.07818743f, 0.08021983f, 0.082282715f, 0.084376216f, 0.086500466f, 0.088655606f, 0.09084173f, 0.09305898f, 0.095307484f, 0.09758736f, 0.09989874f, 0.10224175f, 0.10461649f, 0.10702311f, 0.10946172f, 0.111932434f, 0.11443538f, 0.116970696f, 0.11953845f, 0.12213881f, 0.12477186f, 0.12743773f, 0.13013652f, 0.13286836f, 0.13563336f, 0.13843165f, 0.14126332f, 0.1441285f, 0.1470273f, 0.14995982f, 0.15292618f, 0.1559265f, 0.15896086f, 0.16202943f, 0.16513224f, 0.16826946f, 0.17144115f, 0.17464745f, 0.17788847f, 0.1811643f, 0.18447503f, 0.1878208f, 0.19120172f, 0.19461787f, 0.19806935f, 0.2015563f, 0.20507877f, 0.2086369f, 0.21223079f, 0.21586053f, 0.21952623f, 0.22322798f, 0.22696589f, 0.23074007f, 0.23455065f, 0.23839766f, 0.2422812f, 0.2462014f, 0.25015837f, 0.25415218f, 0.2581829f, 0.26225072f, 0.26635566f, 0.27049786f, 0.27467737f, 0.27889434f, 0.2831488f, 0.2874409f, 0.2917707f, 0.29613832f, 0.30054384f, 0.30498737f, 0.30946895f, 0.31398875f, 0.31854683f, 0.32314324f, 0.32777813f, 0.33245158f, 0.33716366f, 0.34191445f, 0.3467041f, 0.3515327f, 0.35640025f, 0.36130688f, 0.3662527f, 0.37123778f, 0.37626222f, 0.3813261f, 0.38642952f, 0.39157256f, 0.3967553f, 0.40197787f, 0.4072403f, 0.4125427f, 0.41788515f, 0.42326775f, 0.42869055f, 0.4341537f, 0.43965724f, 0.44520125f, 0.45078585f, 0.45641106f, 0.46207705f, 0.46778384f, 0.47353154f, 0.47932023f, 0.48514998f, 0.4910209f, 0.49693304f, 0.5028866f, 0.50888145f, 0.5149178f, 0.5209957f, 0.52711535f, 0.5332766f, 0.5394797f, 0.5457247f, 0.5520116f, 0.5583406f, 0.5647117f, 0.57112503f, 0.57758063f, 0.5840786f, 0.590619f, 0.597202f, 0.60382754f, 0.61049575f, 0.61720675f, 0.62396055f, 0.63075733f, 0.637597f, 0.6444799f, 0.6514058f, 0.65837497f, 0.66538745f, 0.67244333f, 0.6795426f, 0.68668544f, 0.69387203f, 0.70110214f, 0.70837605f, 0.7156938f, 0.72305536f, 0.730461f, 0.7379107f, 0.7454045f, 0.75294244f, 0.76052475f, 0.7681514f, 0.77582246f, 0.78353804f, 0.79129815f, 0.79910296f, 0.8069525f, 0.8148468f, 0.822786f, 0.8307701f, 0.83879924f, 0.84687346f, 0.8549928f, 0.8631574f, 0.87136734f, 0.8796226f, 0.8879232f, 0.89626956f, 0.90466136f, 0.913099f, 0.92158204f, 0.93011117f, 0.9386859f, 0.9473069f, 0.9559735f, 0.9646866f, 0.9734455f, 0.98225087f, 0.9911022f, 1.0f};
    private static final int MIN_BITS = 0x39000000;
    private static final int MAX_BITS = 0x3F7FFFFF;
    private static final float MIN_BOUND = Float.intBitsToFloat(0x39000000);
    private static final float MAX_BOUND = Float.intBitsToFloat(0x3F7FFFFF);

    public static float srgbToLinear(int c) {
        return FROM_SRGB8_TABLE[c & 0xFF];
    }

    public static int linearToSrgb(float r, float g, float b, int a) {
        return class_1011.method_24031((int)a, (int)ColorSRGB.linearToSrgb(b), (int)ColorSRGB.linearToSrgb(g), (int)ColorSRGB.linearToSrgb(r));
    }

    private static int linearToSrgb(float c) {
        int inputBits = Float.floatToRawIntBits(ColorSRGB.clampLinearInput(c));
        int entry = TO_SRGB8_TABLE[inputBits - 0x39000000 >> 20];
        int bias = entry >>> 16 << 9;
        int scale = entry & 0xFFFF;
        int t = inputBits >>> 12 & 0xFF;
        return bias + scale * t >>> 16;
    }

    private static float clampLinearInput(float input) {
        if (!(input > MIN_BOUND)) {
            input = MIN_BOUND;
        }
        if (input > MAX_BOUND) {
            input = MAX_BOUND;
        }
        return input;
    }
}

