/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client;

import java.io.IOException;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.util.FlawlessFrames;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodiumClientMod
implements ClientModInitializer {
    private static SodiumGameOptions CONFIG;
    private static Logger LOGGER;
    private static String MOD_VERSION;

    public void onInitializeClient() {
        ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("sodium").orElseThrow(NullPointerException::new);
        MOD_VERSION = mod.getMetadata().getVersion().getFriendlyString();
        LOGGER = LoggerFactory.getLogger((String)"Sodium");
        CONFIG = SodiumClientMod.loadConfig();
        FlawlessFrames.onClientInitialization();
    }

    public static SodiumGameOptions options() {
        if (CONFIG == null) {
            throw new IllegalStateException("Config not yet available");
        }
        return CONFIG;
    }

    public static Logger logger() {
        if (LOGGER == null) {
            throw new IllegalStateException("Logger not yet available");
        }
        return LOGGER;
    }

    private static SodiumGameOptions loadConfig() {
        try {
            return SodiumGameOptions.load();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load configuration file", (Throwable)e);
            LOGGER.error("Using default configuration file in read-only mode");
            SodiumGameOptions config = new SodiumGameOptions();
            config.setReadOnly();
            return config;
        }
    }

    public static void restoreDefaultOptions() {
        CONFIG = SodiumGameOptions.defaults();
        try {
            CONFIG.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config file", e);
        }
    }

    public static String getVersion() {
        if (MOD_VERSION == null) {
            throw new NullPointerException("Mod version hasn't been populated yet");
        }
        return MOD_VERSION;
    }

    public static boolean isDirectMemoryAccessEnabled() {
        return SodiumClientMod.options().advanced.allowDirectMemoryAccess;
    }
}

