/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.client.world.cloned.PalettedContainerAccessor;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalette;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPaletteFallback;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalleteArray;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2816;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import net.minecraft.class_3341;
import net.minecraft.class_3508;
import net.minecraft.class_4076;
import net.minecraft.class_6490;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import net.minecraft.class_7924;

public class ClonedChunkSection {
    private static final class_1944[] LIGHT_TYPES = class_1944.values();
    private class_2826 EMPTY_SECTION;
    private static final class_2841<class_2680> EMPTY_CONTAINER = new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569);
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private final ClonedChunkSectionCache backingCache;
    private final Short2ObjectMap<class_2586> blockEntities;
    private final Short2ObjectMap<Object> renderAttachments;
    private final class_2804[] lightDataArrays;
    private class_4076 pos;
    private class_3508 blockStateData;
    private ClonedPalette<class_2680> blockStatePalette;
    private class_7522<class_6880<class_1959>> biomeData;

    ClonedChunkSection(ClonedChunkSectionCache backingCache) {
        this.backingCache = backingCache;
        this.blockEntities = new Short2ObjectOpenHashMap();
        this.renderAttachments = new Short2ObjectOpenHashMap();
        this.lightDataArrays = new class_2804[LIGHT_TYPES.length];
    }

    public void init(class_1937 world, class_4076 pos) {
        this.EMPTY_SECTION = new class_2826(EMPTY_CONTAINER, (class_7522)new class_2841(world.method_30349().method_30530(class_7924.field_41236).method_40295(), (Object)world.method_30349().method_30530(class_7924.field_41236).method_40290(class_1972.field_9451), class_2841.class_6563.field_34570));
        class_2818 chunk = world.method_8497(pos.method_10263(), pos.method_10260());
        if (chunk == null) {
            throw new RuntimeException("Couldn't retrieve chunk at " + pos.method_18692());
        }
        class_2826 section = ClonedChunkSection.getChunkSection(world, (class_2791)chunk, pos);
        if (section == null) {
            section = this.EMPTY_SECTION;
        }
        this.reset(pos);
        this.copyBlockData(section);
        this.copyLightData(world);
        this.copyBiomeData(section);
        this.copyBlockEntities(chunk, pos);
    }

    private void reset(class_4076 pos) {
        this.pos = pos;
        this.blockEntities.clear();
        this.renderAttachments.clear();
        this.blockStateData = null;
        this.blockStatePalette = null;
        this.biomeData = null;
        Arrays.fill(this.lightDataArrays, null);
    }

    private void copyBlockData(class_2826 section) {
        class_2841.class_6561 container = PalettedContainerAccessor.getData(section.method_12265());
        this.blockStateData = ClonedChunkSection.copyBlockData(container);
        this.blockStatePalette = ClonedChunkSection.copyPalette(container);
    }

    private void copyLightData(class_1937 world) {
        for (class_1944 type : LIGHT_TYPES) {
            this.lightDataArrays[type.ordinal()] = world.method_22336().method_15562(type).method_15544(this.pos);
        }
    }

    private void copyBiomeData(class_2826 section) {
        this.biomeData = section.method_38294();
    }

    public int getLightLevel(class_1944 type, int x, int y, int z) {
        class_2804 array = this.lightDataArrays[type.ordinal()];
        if (array != null) {
            return array.method_12139(x, y, z);
        }
        return 0;
    }

    private void copyBlockEntities(class_2818 chunk, class_4076 chunkCoord) {
        class_3341 box = new class_3341(chunkCoord.method_19527(), chunkCoord.method_19528(), chunkCoord.method_19529(), chunkCoord.method_19530(), chunkCoord.method_19531(), chunkCoord.method_19532());
        for (Map.Entry entry : chunk.method_12214().entrySet()) {
            class_2338 pos = (class_2338)entry.getKey();
            class_2586 entity = (class_2586)entry.getValue();
            if (!box.method_14662((class_2382)pos)) continue;
            this.blockEntities.put(class_4076.method_19454((class_2338)pos), (Object)entity);
        }
        for (Short2ObjectMap.Entry entry : Short2ObjectMaps.fastIterable(this.blockEntities)) {
            Object object = entry.getValue();
            if (!(object instanceof RenderAttachmentBlockEntity)) continue;
            RenderAttachmentBlockEntity entity = (RenderAttachmentBlockEntity)object;
            this.renderAttachments.put(entry.getShortKey(), entity.getRenderAttachmentData());
        }
    }

    public class_6880<class_1959> getBiome(int x, int y, int z) {
        return (class_6880)this.biomeData.method_12321(x, y, z);
    }

    public class_2586 getBlockEntity(int x, int y, int z) {
        return (class_2586)this.blockEntities.get(ClonedChunkSection.packLocal(x, y, z));
    }

    public Object getBlockEntityRenderAttachment(int x, int y, int z) {
        return this.renderAttachments.get(ClonedChunkSection.packLocal(x, y, z));
    }

    public class_3508 getBlockData() {
        return this.blockStateData;
    }

    public ClonedPalette<class_2680> getBlockPalette() {
        return this.blockStatePalette;
    }

    public class_4076 getPosition() {
        return this.pos;
    }

    private static ClonedPalette<class_2680> copyPalette(class_2841.class_6561<class_2680> container) {
        class_2837 palette = container.comp_119();
        if (palette instanceof class_2816) {
            return new ClonedPaletteFallback<class_2680>(class_2248.field_10651);
        }
        class_2680[] array = new class_2680[container.comp_119().method_12197()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (class_2680)palette.method_12288(i);
        }
        return new ClonedPalleteArray<class_2680>(array);
    }

    private static class_3508 copyBlockData(class_2841.class_6561<class_2680> container) {
        class_6490 storage = container.comp_118();
        long[] data = storage.method_15212();
        int bits = container.comp_74().comp_73();
        if (bits == 0) {
            return new class_3508(1, storage.method_15215());
        }
        return new class_3508(bits, storage.method_15215(), (long[])data.clone());
    }

    private static class_2826 getChunkSection(class_1937 world, class_2791 chunk, class_4076 pos) {
        class_2826 section = null;
        if (!world.method_31601(class_4076.method_18688((int)pos.method_10264()))) {
            section = chunk.method_12006()[world.method_31603(pos.method_10264())];
        }
        return section;
    }

    public void acquireReference() {
        this.referenceCount.incrementAndGet();
    }

    public boolean releaseReference() {
        return this.referenceCount.decrementAndGet() <= 0;
    }

    public ClonedChunkSectionCache getBackingCache() {
        return this.backingCache;
    }

    private static short packLocal(int x, int y, int z) {
        return (short)(x << 8 | z << 4 | y);
    }
}

