/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.color;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.color.DefaultColorProviders;
import me.jellysquid.mods.sodium.client.model.color.interop.BlockColorsExtended;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_322;
import net.minecraft.class_324;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class ColorProviderRegistry {
    private final Reference2ReferenceMap<class_2248, ColorProvider<class_2680>> blocks = new Reference2ReferenceOpenHashMap();
    private final Reference2ReferenceMap<class_3611, ColorProvider<class_3610>> fluids = new Reference2ReferenceOpenHashMap();

    public ColorProviderRegistry(class_324 blockColors) {
        Reference2ReferenceMap<class_2248, class_322> providers = BlockColorsExtended.getProviders(blockColors);
        for (Reference2ReferenceMap.Entry entry : providers.reference2ReferenceEntrySet()) {
            this.blocks.put((Object)((class_2248)entry.getKey()), DefaultColorProviders.adapt((class_322)entry.getValue()));
        }
        this.installOverrides();
    }

    private void installOverrides() {
        this.registerBlocks(DefaultColorProviders.GrassColorProvider.BLOCKS, class_2246.field_10219, class_2246.field_10112, class_2246.field_10479, class_2246.field_10128, class_2246.field_42750, class_2246.field_10424, class_2246.field_10313, class_2246.field_10214);
        this.registerBlocks(DefaultColorProviders.FoliageColorProvider.BLOCKS, class_2246.field_10503, class_2246.field_10335, class_2246.field_10098, class_2246.field_10035, class_2246.field_10597, class_2246.field_37551);
        this.registerBlocks(DefaultColorProviders.WaterColorProvider.BLOCKS, class_2246.field_10382, class_2246.field_10422, class_2246.field_27097);
        this.registerFluids(DefaultColorProviders.WaterColorProvider.FLUIDS, new class_3611[]{class_3612.field_15910, class_3612.field_15909});
    }

    private void registerBlocks(ColorProvider<class_2680> resolver, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            this.blocks.put((Object)block, resolver);
        }
    }

    private void registerFluids(ColorProvider<class_3610> resolver, class_3611 ... fluids) {
        for (class_3611 fluid : fluids) {
            this.fluids.put((Object)fluid, resolver);
        }
    }

    public ColorProvider<class_2680> getColorProvider(class_2248 block) {
        return (ColorProvider)this.blocks.get((Object)block);
    }

    public ColorProvider<class_3610> getColorProvider(class_3611 fluid) {
        return (ColorProvider)this.fluids.get((Object)fluid);
    }
}

