/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.executor;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Semaphore;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJob;
import org.jetbrains.annotations.Nullable;

class ChunkJobQueue {
    private final ConcurrentLinkedDeque<ChunkJob> jobs = new ConcurrentLinkedDeque();
    private final Semaphore semaphore = new Semaphore(0);

    ChunkJobQueue() {
    }

    public void add(ChunkJob job, boolean important) {
        if (important) {
            this.jobs.addFirst(job);
        } else {
            this.jobs.addLast(job);
        }
        this.semaphore.release(1);
    }

    @Nullable
    public ChunkJob waitForNextJob() throws InterruptedException {
        this.semaphore.acquire();
        return this.getNextTask();
    }

    public boolean stealJob(ChunkJob job) {
        if (!this.semaphore.tryAcquire()) {
            return false;
        }
        boolean success = this.jobs.remove(job);
        if (!success) {
            this.semaphore.release(1);
        }
        return success;
    }

    @Nullable
    private ChunkJob getNextTask() {
        return this.jobs.poll();
    }

    public Collection<ChunkJob> removeAll() {
        ArrayDeque<ChunkJob> list = new ArrayDeque<ChunkJob>();
        while (this.semaphore.tryAcquire()) {
            ChunkJob task = this.jobs.poll();
            if (task == null) continue;
            list.add(task);
        }
        return list;
    }

    public int size() {
        return this.semaphore.availablePermits();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

