/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMaps;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.Map;
import me.jellysquid.mods.sodium.client.world.ReadableContainerExtended;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2804;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3341;
import net.minecraft.class_4076;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClonedChunkSection {
    private static final class_2804 DEFAULT_SKY_LIGHT_ARRAY = new class_2804(15);
    private static final class_2804 DEFAULT_BLOCK_LIGHT_ARRAY = new class_2804(0);
    private final class_4076 pos;
    @Nullable
    private final Int2ReferenceMap<class_2586> blockEntityMap;
    @Nullable
    private final Int2ReferenceMap<Object> blockEntityAttachmentMap;
    @Nullable
    private final class_2804[] lightDataArrays;
    @Nullable
    private final class_7522<class_2680> blockData;
    @Nullable
    private final class_7522<class_6880<class_1959>> biomeData;
    private long lastUsedTimestamp = Long.MAX_VALUE;

    public ClonedChunkSection(class_1937 world, class_2818 chunk, @Nullable class_2826 section, class_4076 pos) {
        this.pos = pos;
        class_7522 blockData = null;
        class_7522 biomeData = null;
        Int2ReferenceMap<class_2586> blockEntityMap = null;
        Int2ReferenceMap<Object> blockEntityAttachmentMap = null;
        if (section != null) {
            if (!section.method_38292()) {
                blockData = ReadableContainerExtended.clone(section.method_12265());
                blockEntityMap = ClonedChunkSection.copyBlockEntities(chunk, pos);
                if (blockEntityMap != null) {
                    blockEntityAttachmentMap = ClonedChunkSection.copyBlockEntityAttachments(blockEntityMap);
                }
            }
            biomeData = ReadableContainerExtended.clone(section.method_38294());
        }
        this.blockData = blockData;
        this.biomeData = biomeData;
        this.blockEntityMap = blockEntityMap;
        this.blockEntityAttachmentMap = blockEntityAttachmentMap;
        this.lightDataArrays = ClonedChunkSection.copyLightData(world, pos);
    }

    @NotNull
    private static class_2804[] copyLightData(class_1937 world, class_4076 pos) {
        class_2804[] arrays = new class_2804[2];
        arrays[class_1944.field_9282.ordinal()] = ClonedChunkSection.copyLightArray(world, class_1944.field_9282, pos);
        if (world.method_8597().comp_642()) {
            arrays[class_1944.field_9284.ordinal()] = ClonedChunkSection.copyLightArray(world, class_1944.field_9284, pos);
        }
        return arrays;
    }

    @NotNull
    private static class_2804 copyLightArray(class_1937 world, class_1944 type, class_4076 pos) {
        class_2804 array = world.method_22336().method_15562(type).method_15544(pos);
        if (array == null) {
            array = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case class_1944.field_9284 -> DEFAULT_SKY_LIGHT_ARRAY;
                case class_1944.field_9282 -> DEFAULT_BLOCK_LIGHT_ARRAY;
            };
        }
        return array;
    }

    @Nullable
    private static Int2ReferenceMap<class_2586> copyBlockEntities(class_2818 chunk, class_4076 chunkCoord) {
        class_3341 box = new class_3341(chunkCoord.method_19527(), chunkCoord.method_19528(), chunkCoord.method_19529(), chunkCoord.method_19530(), chunkCoord.method_19531(), chunkCoord.method_19532());
        Int2ReferenceOpenHashMap blockEntities = null;
        for (Map.Entry entry : chunk.method_12214().entrySet()) {
            class_2338 pos = (class_2338)entry.getKey();
            class_2586 entity = (class_2586)entry.getValue();
            if (!box.method_14662((class_2382)pos)) continue;
            if (blockEntities == null) {
                blockEntities = new Int2ReferenceOpenHashMap();
            }
            blockEntities.put(WorldSlice.getLocalBlockIndex(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF), (Object)entity);
        }
        return blockEntities;
    }

    @Nullable
    private static Int2ReferenceMap<Object> copyBlockEntityAttachments(Int2ReferenceMap<class_2586> blockEntities) {
        Int2ReferenceOpenHashMap blockEntityAttachments = null;
        for (Int2ReferenceMap.Entry entry : Int2ReferenceMaps.fastIterable(blockEntities)) {
            Object object = entry.getValue();
            if (!(object instanceof RenderAttachmentBlockEntity)) continue;
            RenderAttachmentBlockEntity holder = (RenderAttachmentBlockEntity)object;
            if (blockEntityAttachments == null) {
                blockEntityAttachments = new Int2ReferenceOpenHashMap();
            }
            blockEntityAttachments.put(entry.getIntKey(), holder.getRenderAttachmentData());
        }
        return blockEntityAttachments;
    }

    public class_4076 getPosition() {
        return this.pos;
    }

    @Nullable
    public class_7522<class_2680> getBlockData() {
        return this.blockData;
    }

    @Nullable
    public class_7522<class_6880<class_1959>> getBiomeData() {
        return this.biomeData;
    }

    @Nullable
    public Int2ReferenceMap<class_2586> getBlockEntityMap() {
        return this.blockEntityMap;
    }

    @Nullable
    public Int2ReferenceMap<Object> getBlockEntityAttachmentMap() {
        return this.blockEntityAttachmentMap;
    }

    @Nullable
    public class_2804 getLightArray(class_1944 lightType) {
        return this.lightDataArrays[lightType.ordinal()];
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public void setLastUsedTimestamp(long timestamp) {
        this.lastUsedTimestamp = timestamp;
    }
}

