/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline;

import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.color.ColorProviderRegistry;
import me.jellysquid.mods.sodium.client.model.color.DefaultColorProviders;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuad;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadViewMutable;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.util.DirectionUtil;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5431;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class FluidRenderer {
    private static final float EPSILON = 0.001f;
    private final class_2338.class_2339 scratchPos = new class_2338.class_2339();
    private final MutableFloat scratchHeight = new MutableFloat(0.0f);
    private final MutableInt scratchSamples = new MutableInt();
    private final ModelQuadViewMutable quad = new ModelQuad();
    private final LightPipelineProvider lighters;
    private final QuadLightData quadLightData = new QuadLightData();
    private final int[] quadColors = new int[4];
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private final ColorProviderRegistry colorProviderRegistry;

    public FluidRenderer(ColorProviderRegistry colorProviderRegistry, LightPipelineProvider lighters) {
        this.quad.setNormal(NormI8.pack(0.0f, 1.0f, 0.0f));
        this.lighters = lighters;
        this.colorProviderRegistry = colorProviderRegistry;
    }

    private boolean isFluidOccluded(class_1920 world, int x, int y, int z, class_2350 dir, class_3611 fluid) {
        class_2338.class_2339 pos = this.scratchPos.method_10103(x, y, z);
        class_2680 blockState = world.method_8320((class_2338)pos);
        class_2338.class_2339 adjPos = this.scratchPos.method_10103(x + dir.method_10148(), y + dir.method_10164(), z + dir.method_10165());
        if (blockState.method_26225()) {
            return world.method_8316((class_2338)adjPos).method_15772().method_15780(fluid) || blockState.method_30368((class_1922)world, (class_2338)pos, dir, class_5431.field_25822);
        }
        return world.method_8316((class_2338)adjPos).method_15772().method_15780(fluid);
    }

    private boolean isSideExposed(class_1920 world, int x, int y, int z, class_2350 dir, float height) {
        class_2338.class_2339 pos = this.scratchPos.method_10103(x + dir.method_10148(), y + dir.method_10164(), z + dir.method_10165());
        class_2680 blockState = world.method_8320((class_2338)pos);
        if (blockState.method_26225()) {
            class_265 shape = blockState.method_26201((class_1922)world, (class_2338)pos);
            if (shape == class_259.method_1077()) {
                return dir == class_2350.field_11036;
            }
            if (shape.method_1110()) {
                return true;
            }
            class_265 threshold = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)height, (double)1.0);
            return !class_259.method_1083((class_265)threshold, (class_265)shape, (class_2350)dir);
        }
        return true;
    }

    public void render(WorldSlice world, class_3610 fluidState, class_2338 blockPos, class_2338 offset, ChunkBuildBuffers buffers) {
        float northEastHeight;
        float southEastHeight;
        float southWestHeight;
        float northWestHeight;
        Material material = DefaultMaterials.forFluidState(fluidState);
        ChunkModelBuilder meshBuilder = buffers.get(material);
        int posX = blockPos.method_10263();
        int posY = blockPos.method_10264();
        int posZ = blockPos.method_10260();
        class_3611 fluid = fluidState.method_15772();
        boolean sfUp = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11036, fluid);
        boolean sfDown = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11033, fluid) || !this.isSideExposed(world, posX, posY, posZ, class_2350.field_11033, 0.8888889f);
        boolean sfNorth = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11043, fluid);
        boolean sfSouth = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11035, fluid);
        boolean sfWest = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11039, fluid);
        boolean sfEast = this.isFluidOccluded(world, posX, posY, posZ, class_2350.field_11034, fluid);
        if (sfUp && sfDown && sfEast && sfWest && sfNorth && sfSouth) {
            return;
        }
        boolean isWater = fluidState.method_15767(class_3486.field_15517);
        FluidRenderHandler handler = FluidRenderer.getFluidRenderHandler(fluidState);
        ColorProvider<class_3610> colorProvider = this.getColorProvider(fluid, handler);
        class_1058[] sprites = handler.getFluidSprites((class_1920)world, blockPos, fluidState);
        float fluidHeight = this.fluidHeight(world, fluid, blockPos, class_2350.field_11036);
        if (fluidHeight >= 1.0f) {
            northWestHeight = 1.0f;
            southWestHeight = 1.0f;
            southEastHeight = 1.0f;
            northEastHeight = 1.0f;
        } else {
            class_2338.class_2339 scratchPos = new class_2338.class_2339();
            float heightNorth = this.fluidHeight(world, fluid, (class_2338)scratchPos.method_25505((class_2382)blockPos, class_2350.field_11043), class_2350.field_11043);
            float heightSouth = this.fluidHeight(world, fluid, (class_2338)scratchPos.method_25505((class_2382)blockPos, class_2350.field_11035), class_2350.field_11035);
            float heightEast = this.fluidHeight(world, fluid, (class_2338)scratchPos.method_25505((class_2382)blockPos, class_2350.field_11034), class_2350.field_11034);
            float heightWest = this.fluidHeight(world, fluid, (class_2338)scratchPos.method_25505((class_2382)blockPos, class_2350.field_11039), class_2350.field_11039);
            northWestHeight = this.fluidCornerHeight(world, fluid, fluidHeight, heightNorth, heightWest, (class_2338)scratchPos.method_10101((class_2382)blockPos).method_10098(class_2350.field_11043).method_10098(class_2350.field_11039));
            southWestHeight = this.fluidCornerHeight(world, fluid, fluidHeight, heightSouth, heightWest, (class_2338)scratchPos.method_10101((class_2382)blockPos).method_10098(class_2350.field_11035).method_10098(class_2350.field_11039));
            southEastHeight = this.fluidCornerHeight(world, fluid, fluidHeight, heightSouth, heightEast, (class_2338)scratchPos.method_10101((class_2382)blockPos).method_10098(class_2350.field_11035).method_10098(class_2350.field_11034));
            northEastHeight = this.fluidCornerHeight(world, fluid, fluidHeight, heightNorth, heightEast, (class_2338)scratchPos.method_10101((class_2382)blockPos).method_10098(class_2350.field_11043).method_10098(class_2350.field_11034));
        }
        float yOffset = sfDown ? 0.0f : 0.001f;
        ModelQuadViewMutable quad = this.quad;
        LightMode lightMode = isWater && class_310.method_1588() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        quad.setFlags(0);
        if (!sfUp && this.isSideExposed(world, posX, posY, posZ, class_2350.field_11036, Math.min(Math.min(northWestHeight, southWestHeight), Math.min(southEastHeight, northEastHeight)))) {
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            ModelQuadFacing facing;
            class_1058 sprite;
            northWestHeight -= 0.001f;
            southWestHeight -= 0.001f;
            southEastHeight -= 0.001f;
            northEastHeight -= 0.001f;
            class_243 velocity = fluidState.method_15758((class_1922)world, blockPos);
            if (velocity.field_1352 == 0.0 && velocity.field_1350 == 0.0) {
                sprite = sprites[0];
                facing = ModelQuadFacing.POS_Y;
                u1 = sprite.method_4580(0.0f);
                v1 = sprite.method_4570(0.0f);
                u2 = u1;
                v2 = sprite.method_4570(1.0f);
                u3 = sprite.method_4580(1.0f);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                sprite = sprites[1];
                facing = ModelQuadFacing.UNASSIGNED;
                float dir = (float)class_3532.method_15349((double)velocity.field_1350, (double)velocity.field_1352) - 1.5707964f;
                float sin = class_3532.method_15374((float)dir) * 0.25f;
                float cos = class_3532.method_15362((float)dir) * 0.25f;
                u1 = sprite.method_4580(0.5f + (-cos - sin));
                v1 = sprite.method_4570(0.5f + -cos + sin);
                u2 = sprite.method_4580(0.5f + -cos + sin);
                v2 = sprite.method_4570(0.5f + cos + sin);
                u3 = sprite.method_4580(0.5f + cos + sin);
                v3 = sprite.method_4570(0.5f + (cos - sin));
                u4 = sprite.method_4580(0.5f + (cos - sin));
                v4 = sprite.method_4570(0.5f + (-cos - sin));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s3 = sprites[0].method_23842();
            u1 = class_3532.method_16439((float)s3, (float)u1, (float)uAvg);
            u2 = class_3532.method_16439((float)s3, (float)u2, (float)uAvg);
            u3 = class_3532.method_16439((float)s3, (float)u3, (float)uAvg);
            u4 = class_3532.method_16439((float)s3, (float)u4, (float)uAvg);
            v1 = class_3532.method_16439((float)s3, (float)v1, (float)vAvg);
            v2 = class_3532.method_16439((float)s3, (float)v2, (float)vAvg);
            v3 = class_3532.method_16439((float)s3, (float)v3, (float)vAvg);
            v4 = class_3532.method_16439((float)s3, (float)v4, (float)vAvg);
            quad.setSprite(sprite);
            FluidRenderer.setVertex(quad, 0, 0.0f, northWestHeight, 0.0f, u1, v1);
            FluidRenderer.setVertex(quad, 1, 0.0f, southWestHeight, 1.0f, u2, v2);
            FluidRenderer.setVertex(quad, 2, 1.0f, southEastHeight, 1.0f, u3, v3);
            FluidRenderer.setVertex(quad, 3, 1.0f, northEastHeight, 0.0f, u4, v4);
            this.updateQuad(quad, world, blockPos, lighter, class_2350.field_11036, 1.0f, colorProvider, fluidState);
            this.writeQuad(meshBuilder, material, offset, quad, facing, false);
            if (fluidState.method_15756((class_1922)world, (class_2338)this.scratchPos.method_10103(posX, posY + 1, posZ))) {
                this.writeQuad(meshBuilder, material, offset, quad, ModelQuadFacing.NEG_Y, true);
            }
        }
        if (!sfDown) {
            class_1058 sprite = sprites[0];
            float minU = sprite.method_4594();
            float maxU = sprite.method_4577();
            float minV = sprite.method_4593();
            float maxV = sprite.method_4575();
            quad.setSprite(sprite);
            FluidRenderer.setVertex(quad, 0, 0.0f, yOffset, 1.0f, minU, maxV);
            FluidRenderer.setVertex(quad, 1, 0.0f, yOffset, 0.0f, minU, minV);
            FluidRenderer.setVertex(quad, 2, 1.0f, yOffset, 0.0f, maxU, minV);
            FluidRenderer.setVertex(quad, 3, 1.0f, yOffset, 1.0f, maxU, maxV);
            this.updateQuad(quad, world, blockPos, lighter, class_2350.field_11033, 1.0f, colorProvider, fluidState);
            this.writeQuad(meshBuilder, material, offset, quad, ModelQuadFacing.NEG_Y, false);
        }
        quad.setFlags(6);
        block6: for (class_2350 dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            class_2338.class_2339 adjPos;
            class_2680 adjBlock;
            float z2;
            float z1;
            float x2;
            float x1;
            float c2;
            float c1;
            switch (dir) {
                case field_11043: {
                    if (sfNorth) continue block6;
                    c1 = northWestHeight;
                    c2 = northEastHeight;
                    x1 = 0.0f;
                    x2 = 1.0f;
                    z2 = z1 = 0.001f;
                    break;
                }
                case field_11035: {
                    if (sfSouth) continue block6;
                    c1 = southEastHeight;
                    c2 = southWestHeight;
                    x1 = 1.0f;
                    x2 = 0.0f;
                    z2 = z1 = 0.999f;
                    break;
                }
                case field_11039: {
                    if (sfWest) continue block6;
                    c1 = southWestHeight;
                    c2 = northWestHeight;
                    x2 = x1 = 0.001f;
                    z1 = 1.0f;
                    z2 = 0.0f;
                    break;
                }
                case field_11034: {
                    if (sfEast) continue block6;
                    c1 = northEastHeight;
                    c2 = southEastHeight;
                    x2 = x1 = 0.999f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (!this.isSideExposed(world, posX, posY, posZ, dir, Math.max(c1, c2))) continue;
            int adjX = posX + dir.method_10148();
            int adjY = posY + dir.method_10164();
            int adjZ = posZ + dir.method_10165();
            class_1058 sprite = sprites[1];
            boolean isOverlay = false;
            if (sprites.length > 2 && FluidRenderHandlerRegistry.INSTANCE.isBlockTransparent((adjBlock = world.method_8320((class_2338)(adjPos = this.scratchPos.method_10103(adjX, adjY, adjZ)))).method_26204())) {
                sprite = sprites[2];
                isOverlay = true;
            }
            float u1 = sprite.method_4580(0.0f);
            float u2 = sprite.method_4580(0.5f);
            float v1 = sprite.method_4570((1.0f - c1) * 0.5f);
            float v2 = sprite.method_4570((1.0f - c2) * 0.5f);
            float v3 = sprite.method_4570(0.5f);
            quad.setSprite(sprite);
            FluidRenderer.setVertex(quad, 0, x2, c2, z2, u2, v2);
            FluidRenderer.setVertex(quad, 1, x2, yOffset, z2, u2, v3);
            FluidRenderer.setVertex(quad, 2, x1, yOffset, z1, u1, v3);
            FluidRenderer.setVertex(quad, 3, x1, c1, z1, u1, v1);
            float br = dir.method_10166() == class_2350.class_2351.field_11051 ? 0.8f : 0.6f;
            ModelQuadFacing facing = ModelQuadFacing.fromDirection(dir);
            this.updateQuad(quad, world, blockPos, lighter, dir, br, colorProvider, fluidState);
            this.writeQuad(meshBuilder, material, offset, quad, facing, false);
            if (isOverlay) continue;
            this.writeQuad(meshBuilder, material, offset, quad, facing.getOpposite(), true);
        }
    }

    private ColorProvider<class_3610> getColorProvider(class_3611 fluid, FluidRenderHandler handler) {
        ColorProvider<class_3610> override = this.colorProviderRegistry.getColorProvider(fluid);
        if (override != null) {
            return override;
        }
        return DefaultColorProviders.adapt(handler);
    }

    private static FluidRenderHandler getFluidRenderHandler(class_3610 fluidState) {
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluidState.method_15772());
        if (handler == null) {
            boolean isLava = fluidState.method_15767(class_3486.field_15518);
            handler = FluidRenderHandlerRegistry.INSTANCE.get((class_3611)(isLava ? class_3612.field_15908 : class_3612.field_15910));
        }
        return handler;
    }

    private void updateQuad(ModelQuadView quad, WorldSlice world, class_2338 pos, LightPipeline lighter, class_2350 dir, float brightness, ColorProvider<class_3610> colorProvider, class_3610 fluidState) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, pos, light, null, dir, false);
        colorProvider.getColors(world, pos, fluidState, quad, this.quadColors);
        for (int i = 0; i < 4; ++i) {
            this.quadColors[i] = ColorABGR.withAlpha(this.quadColors[i], light.br[i] * brightness);
        }
    }

    private void writeQuad(ChunkModelBuilder builder, Material material, class_2338 offset, ModelQuadView quad, ModelQuadFacing facing, boolean flip) {
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        for (int i = 0; i < 4; ++i) {
            ChunkVertexEncoder.Vertex out = vertices[flip ? 3 - i : i];
            out.x = (float)offset.method_10263() + quad.getX(i);
            out.y = (float)offset.method_10264() + quad.getY(i);
            out.z = (float)offset.method_10260() + quad.getZ(i);
            out.color = this.quadColors[i];
            out.u = quad.getTexU(i);
            out.v = quad.getTexV(i);
            out.light = this.quadLightData.lm[i];
        }
        class_1058 sprite = quad.getSprite();
        if (sprite != null) {
            builder.addSprite(sprite);
        }
        ChunkMeshBufferBuilder vertexBuffer = builder.getVertexBuffer(facing);
        vertexBuffer.push(vertices, material);
    }

    private static void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
        quad.setX(i, x);
        quad.setY(i, y);
        quad.setZ(i, z);
        quad.setTexU(i, u);
        quad.setTexV(i, v);
    }

    private float fluidCornerHeight(class_1920 world, class_3611 fluid, float fluidHeight, float fluidHeightX, float fluidHeightY, class_2338 blockPos) {
        if (fluidHeightY >= 1.0f || fluidHeightX >= 1.0f) {
            return 1.0f;
        }
        if (fluidHeightY > 0.0f || fluidHeightX > 0.0f) {
            float height = this.fluidHeight(world, fluid, blockPos, class_2350.field_11036);
            if (height >= 1.0f) {
                return 1.0f;
            }
            this.modifyHeight(this.scratchHeight, this.scratchSamples, height);
        }
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeight);
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeightY);
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeightX);
        float result = this.scratchHeight.floatValue() / (float)this.scratchSamples.intValue();
        this.scratchHeight.setValue(0.0f);
        this.scratchSamples.setValue(0);
        return result;
    }

    private void modifyHeight(MutableFloat totalHeight, MutableInt samples, float target) {
        if (target >= 0.8f) {
            totalHeight.add(target * 10.0f);
            samples.add(10);
        } else if (target >= 0.0f) {
            totalHeight.add(target);
            samples.increment();
        }
    }

    private float fluidHeight(class_1920 world, class_3611 fluid, class_2338 blockPos, class_2350 direction) {
        class_2680 blockState = world.method_8320(blockPos);
        class_3610 fluidState = blockState.method_26227();
        if (fluid.method_15780(fluidState.method_15772())) {
            class_3610 fluidStateUp = world.method_8316(blockPos.method_10084());
            if (fluid.method_15780(fluidStateUp.method_15772())) {
                return 1.0f;
            }
            return fluidState.method_20785();
        }
        if (!blockState.method_51367()) {
            return 0.0f;
        }
        return -1.0f;
    }
}

