/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.cache;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import net.minecraft.class_1920;

public class ArrayLightDataCache
extends LightDataAccess {
    private final long[] light;
    private final int xSize;
    private final int ySize;
    private final int zSize;
    private int xOffset;
    private int yOffset;
    private int zOffset;

    public ArrayLightDataCache(int size) {
        this(size, size, size);
    }

    public ArrayLightDataCache(int xSize, int ySize, int zSize) {
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        int len = xSize * ySize * zSize;
        this.light = new long[len];
    }

    public void init(class_1920 world, int x, int y, int z) {
        this.world = world;
        this.xOffset = x;
        this.yOffset = y;
        this.zOffset = z;
        Arrays.fill(this.light, 0L);
    }

    private int index(int x, int y, int z) {
        return (z - this.zOffset) * this.xSize * this.ySize + (y - this.yOffset) * this.zSize + x - this.xOffset;
    }

    @Override
    public long get(int x, int y, int z) {
        int l = this.index(x, y, z);
        long word = this.light[l];
        if (word != 0L) {
            return word;
        }
        this.light[l] = this.compute(x, y, z);
        return this.light[l];
    }
}

