/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.buffer.VertexData;
import me.jellysquid.mods.sodium.client.gl.util.BufferSlice;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.sink.ModelQuadSinkDelegate;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkMeshBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import net.minecraft.class_1161;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_311;

public class ChunkBuildBuffers {
    private final ChunkBuildBufferDelegate[] delegates;
    private final ChunkMeshBuilder[][] buildersByLayer;
    private final List<ChunkMeshBuilder> builders;
    private final GlVertexFormat<?> format;
    private final BlockRenderPassManager renderPassManager;

    public ChunkBuildBuffers(GlVertexFormat<?> format, BlockRenderPassManager renderPassManager) {
        this.format = format;
        this.renderPassManager = renderPassManager;
        this.delegates = new ChunkBuildBufferDelegate[BlockRenderPass.COUNT];
        this.buildersByLayer = new ChunkMeshBuilder[BlockRenderPass.COUNT][ModelQuadFacing.COUNT];
        for (class_1921 layer : class_1921.method_22720()) {
            int passId = this.renderPassManager.getRenderPassId(layer);
            for (ModelQuadFacing facing : ModelQuadFacing.VALUES) {
                this.buildersByLayer[passId][facing.ordinal()] = new ChunkMeshBuilder(format, layer.method_22722() / ModelQuadFacing.COUNT);
            }
            this.delegates[passId] = new ChunkBuildBufferDelegate(this.buildersByLayer[passId]);
        }
        this.builders = Arrays.stream(this.buildersByLayer).flatMap(Arrays::stream).collect(Collectors.toList());
    }

    public ChunkBuildBufferDelegate get(class_1921 layer) {
        return this.delegates[this.renderPassManager.getRenderPassId(layer)];
    }

    public ChunkMeshData createMesh(class_1161 camera, class_2338 pos, BlockRenderPass pass) {
        ChunkMeshBuilder[] builders = this.buildersByLayer[pass.ordinal()];
        ChunkMeshData meshData = new ChunkMeshData();
        int bufferLen = 0;
        for (int facingId = 0; facingId < builders.length; ++facingId) {
            ChunkMeshBuilder builder = builders[facingId];
            if (builder == null) continue;
            builder.finish();
            if (builder.isEmpty()) continue;
            ModelQuadFacing modelQuadFacing = ModelQuadFacing.VALUES[facingId];
            if (pass.isTranslucent()) {
                builder.sortQuads((float)camera.field_5661 - (float)pos.method_10263(), (float)camera.field_5660 - (float)pos.method_10264(), (float)camera.field_5659 - (float)pos.method_10260());
            }
            int start = bufferLen;
            int size = builder.getSize();
            meshData.setModelSlice(modelQuadFacing, new BufferSlice(start, size));
            bufferLen += size;
        }
        if (bufferLen <= 0) {
            return null;
        }
        ByteBuffer buffer = class_311.method_1596((int)bufferLen);
        for (Map.Entry<ModelQuadFacing, BufferSlice> entry : meshData.getSlices()) {
            BufferSlice slice = entry.getValue();
            buffer.position(slice.start);
            ChunkMeshBuilder builder = this.buildersByLayer[pass.ordinal()][entry.getKey().ordinal()];
            builder.copyInto(buffer);
        }
        buffer.flip();
        meshData.setVertexData(new VertexData(buffer, this.format));
        return meshData;
    }

    public void init(ChunkRenderData.Builder renderData) {
        for (ChunkMeshBuilder builder : this.builders) {
            builder.begin(renderData);
        }
    }

    public static class ChunkBuildBufferDelegate
    implements ModelQuadSinkDelegate {
        private final ChunkMeshBuilder[] builders;

        private ChunkBuildBufferDelegate(ChunkMeshBuilder[] builders) {
            this.builders = builders;
        }

        @Override
        public ChunkMeshBuilder get(ModelQuadFacing facing) {
            return this.builders[facing.ordinal()];
        }

        public void setOffset(int x, int y, int z) {
            for (ChunkMeshBuilder builder : this.builders) {
                builder.setOffset(x, y, z);
            }
        }
    }
}

