/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.multidraw;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.render.chunk.multidraw.StructBuffer;
import me.jellysquid.mods.sodium.client.util.UnsafeUtil;
import org.lwjgl.system.MemoryUtil;
import sun.misc.Unsafe;

public abstract class ChunkDrawCallBatcher
extends StructBuffer {
    private static final int STRUCT_SIZE = 16;
    protected final int capacity;

    protected ChunkDrawCallBatcher(int capacity) {
        super(capacity * 16);
        this.capacity = capacity;
    }

    public static ChunkDrawCallBatcher create(int capacity) {
        return UnsafeUtil.isAvailable() ? new UnsafeChunkDrawCallBatcher(capacity) : new NioChunkDrawCallBatcher(capacity);
    }

    public abstract void addIndirectDrawCall(int var1, int var2, int var3, int var4);

    public static class NioChunkDrawCallBatcher
    extends ChunkDrawCallBatcher {
        private int writeOffset;

        public NioChunkDrawCallBatcher(int capacity) {
            super(capacity);
        }

        @Override
        public void begin() {
            super.begin();
            this.writeOffset = 0;
        }

        @Override
        public void addIndirectDrawCall(int first, int count, int baseInstance, int instanceCount) {
            ByteBuffer buf = this.buffer;
            buf.putInt(this.writeOffset, count);
            buf.putInt(this.writeOffset + 4, instanceCount);
            buf.putInt(this.writeOffset + 8, first);
            buf.putInt(this.writeOffset + 12, baseInstance);
            this.writeOffset += 16;
            ++this.count;
        }
    }

    public static class UnsafeChunkDrawCallBatcher
    extends ChunkDrawCallBatcher {
        private static final Unsafe UNSAFE = UnsafeUtil.instanceNullable();
        private final long basePointer;
        private long writePointer;

        public UnsafeChunkDrawCallBatcher(int capacity) {
            super(capacity);
            this.basePointer = MemoryUtil.memAddress((ByteBuffer)this.buffer);
        }

        @Override
        public void begin() {
            super.begin();
            this.writePointer = this.basePointer;
        }

        @Override
        public void addIndirectDrawCall(int first, int count, int baseInstance, int instanceCount) {
            if (this.count++ >= this.capacity) {
                throw new BufferUnderflowException();
            }
            UNSAFE.putInt(this.writePointer, count);
            UNSAFE.putInt(this.writePointer + 4L, instanceCount);
            UNSAFE.putInt(this.writePointer + 8L, first);
            UNSAFE.putInt(this.writePointer + 12L, baseInstance);
            this.writePointer += 16L;
        }
    }
}

