/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import java.util.EnumMap;
import me.jellysquid.mods.sodium.client.gl.SodiumVertexFormats;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkFogMode;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public abstract class ChunkRenderShaderBackend<T extends ChunkGraphicsState, P extends ChunkProgram>
implements ChunkRenderBackend<T> {
    private final EnumMap<ChunkFogMode, P> programs = new EnumMap(ChunkFogMode.class);
    protected final GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> vertexFormat;
    protected P activeProgram;

    public ChunkRenderShaderBackend(GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> format) {
        this.vertexFormat = format;
    }

    @Override
    public final void createShaders() {
        this.programs.put(ChunkFogMode.NONE, this.createShader(ChunkFogMode.NONE, this.vertexFormat));
        this.programs.put(ChunkFogMode.LINEAR, this.createShader(ChunkFogMode.LINEAR, this.vertexFormat));
        this.programs.put(ChunkFogMode.EXP2, this.createShader(ChunkFogMode.EXP2, this.vertexFormat));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P createShader(ChunkFogMode fogMode, GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> format) {
        GlShader vertShader = this.createVertexShader(fogMode);
        GlShader fragShader = this.createFragmentShader(fogMode);
        try {
            ChunkProgram chunkProgram = GlProgram.builder(new class_2960("sodium", "chunk_shader")).attachShader(vertShader).attachShader(fragShader).bindAttribute("a_Pos", format.getAttribute(SodiumVertexFormats.ChunkMeshAttribute.POSITION)).bindAttribute("a_Color", format.getAttribute(SodiumVertexFormats.ChunkMeshAttribute.COLOR)).bindAttribute("a_TexCoord", format.getAttribute(SodiumVertexFormats.ChunkMeshAttribute.TEXTURE)).bindAttribute("a_LightCoord", format.getAttribute(SodiumVertexFormats.ChunkMeshAttribute.LIGHT)).build((program, name) -> this.createShaderProgram(program, name, fogMode));
            return (P)chunkProgram;
        }
        finally {
            vertShader.delete();
            fragShader.delete();
        }
    }

    protected abstract GlShader createFragmentShader(ChunkFogMode var1);

    protected abstract GlShader createVertexShader(ChunkFogMode var1);

    protected abstract P createShaderProgram(class_2960 var1, int var2, ChunkFogMode var3);

    @Override
    public void begin(class_4587 matrixStack) {
        this.activeProgram = (ChunkProgram)this.programs.get((Object)ChunkFogMode.getActiveMode());
        ((GlProgram)this.activeProgram).bind();
        ((ChunkProgram)this.activeProgram).setup(matrixStack);
    }

    @Override
    public void end(class_4587 matrixStack) {
        ((GlProgram)this.activeProgram).unbind();
    }

    @Override
    public void delete() {
        for (ChunkProgram shader : this.programs.values()) {
            shader.delete();
        }
    }

    @Override
    public GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> getVertexFormat() {
        return this.vertexFormat;
    }
}

