/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.buffers;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.consumer.GlyphVertexConsumer;
import me.jellysquid.mods.sodium.client.model.consumer.ParticleVertexConsumer;
import me.jellysquid.mods.sodium.client.model.consumer.QuadVertexConsumer;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.UnsafeUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorU8;
import me.jellysquid.mods.sodium.client.util.math.Matrix4fExtended;
import me.jellysquid.mods.sodium.client.util.math.MatrixUtil;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4581;
import net.minecraft.class_4585;
import net.minecraft.class_4587;
import net.minecraft.class_777;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import sun.misc.Unsafe;

@Mixin(value={class_287.class})
public abstract class MixinBufferBuilder
extends class_4585
implements ParticleVertexConsumer,
QuadVertexConsumer,
GlyphVertexConsumer {
    @Shadow
    private class_293 field_1565;
    @Shadow
    private ByteBuffer field_1555;
    @Shadow
    private int field_20884;
    @Shadow
    private int field_1554;
    @Shadow
    private boolean field_21595;
    @Shadow
    private boolean field_21594;

    @Shadow
    protected abstract void method_1335(int var1);

    @Override
    public void vertexParticle(float x, float y, float z, float u, float v, int color, int light) {
        if (this.field_1565 != class_290.field_1584) {
            this.vertexParticleFallback(x, y, z, u, v, color, light);
            return;
        }
        int size = this.field_1565.method_1362();
        this.method_1335(size);
        if (UnsafeUtil.isAvailable()) {
            this.vertexParticleUnsafe(x, y, z, u, v, color, light);
        } else {
            this.vertexParticleSafe(x, y, z, u, v, color, light);
        }
        this.field_20884 += size;
        ++this.field_1554;
    }

    private void vertexParticleFallback(float x, float y, float z, float u, float v, int color, int light) {
        this.method_22912(x, y, z);
        this.method_22913(u, v);
        this.method_1336(ColorABGR.unpackRed(color), ColorABGR.unpackGreen(color), ColorABGR.unpackBlue(color), ColorABGR.unpackAlpha(color));
        this.method_22916(light);
        this.method_1344();
    }

    private void vertexParticleSafe(float x, float y, float z, float u, float v, int color, int light) {
        int i = this.field_20884;
        ByteBuffer buffer = this.field_1555;
        buffer.putFloat(i, x);
        buffer.putFloat(i += 4, y);
        buffer.putFloat(i += 4, z);
        buffer.putFloat(i += 4, u);
        buffer.putFloat(i += 4, v);
        buffer.putInt(i += 4, color);
        buffer.putInt(i += 4, light);
        i += 4;
    }

    private void vertexParticleUnsafe(float x, float y, float z, float u, float v, int color, int light) {
        long i = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)this.field_20884);
        Unsafe unsafe = UnsafeUtil.instance();
        unsafe.putFloat(i, x);
        unsafe.putFloat(i += 4L, y);
        unsafe.putFloat(i += 4L, z);
        unsafe.putFloat(i += 4L, u);
        unsafe.putFloat(i += 4L, v);
        unsafe.putInt(i += 4L, color);
        unsafe.putInt(i += 4L, light);
        i += 4L;
    }

    @Override
    public void vertexQuad(float x, float y, float z, int color, float u, float v, int light, int overlay, int normal) {
        if (this.field_20889) {
            throw new IllegalStateException();
        }
        if (!this.field_21594) {
            this.vertexQuadFallback(x, y, z, color, u, v, overlay, light, normal);
            return;
        }
        int size = this.field_1565.method_1362();
        this.method_1335(size);
        if (UnsafeUtil.isAvailable()) {
            this.vertexQuadUnsafe(x, y, z, color, u, v, overlay, light, normal);
        } else {
            this.vertexQuadSafe(x, y, z, color, u, v, overlay, light, normal);
        }
        this.field_20884 += size;
        ++this.field_1554;
    }

    private void vertexQuadFallback(float x, float y, float z, int color, float u, float v, int overlay, int light, int normal) {
        this.method_22912(x, y, z);
        this.method_1336(ColorABGR.unpackRed(color), ColorABGR.unpackGreen(color), ColorABGR.unpackBlue(color), ColorABGR.unpackAlpha(color));
        this.method_22913(u, v);
        if (this.field_21595) {
            this.method_22922(overlay);
        }
        this.method_22916(light);
        this.method_22914(Norm3b.unpackX(normal), Norm3b.unpackY(normal), Norm3b.unpackZ(normal));
        this.method_1344();
    }

    private void vertexQuadUnsafe(float x, float y, float z, int color, float u, float v, int overlay, int light, int normal) {
        long i = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)this.field_20884);
        Unsafe unsafe = UnsafeUtil.instance();
        unsafe.putFloat(i, x);
        unsafe.putFloat(i += 4L, y);
        unsafe.putFloat(i += 4L, z);
        unsafe.putInt(i += 4L, color);
        unsafe.putFloat(i += 4L, u);
        unsafe.putFloat(i += 4L, v);
        i += 4L;
        if (this.field_21595) {
            unsafe.putInt(i, overlay);
            i += 4L;
        }
        unsafe.putInt(i, light);
        unsafe.putInt(i += 4L, normal);
    }

    private void vertexQuadSafe(float x, float y, float z, int color, float u, float v, int overlay, int light, int normal) {
        int i = this.field_20884;
        ByteBuffer buffer = this.field_1555;
        buffer.putFloat(i, x);
        buffer.putFloat(i += 4, y);
        buffer.putFloat(i += 4, z);
        buffer.putInt(i += 4, color);
        buffer.putFloat(i += 4, u);
        buffer.putFloat(i += 4, v);
        i += 4;
        if (this.field_21595) {
            buffer.putInt(i, overlay);
            i += 4;
        }
        buffer.putInt(i, light);
        buffer.putInt(i += 4, normal);
    }

    public void method_22920(class_4587.class_4665 matrices, class_777 quad, float[] brightnessTable, float r, float g, float b, int[] light, int overlay, boolean colorize) {
        if (!this.field_21594) {
            super.method_22920(matrices, quad, brightnessTable, r, g, b, light, overlay, colorize);
            return;
        }
        if (this.field_20889) {
            throw new IllegalStateException();
        }
        ModelQuadView quadView = (ModelQuadView)quad;
        class_1159 modelMatrix = matrices.method_23761();
        class_4581 normalMatrix = matrices.method_23762();
        int norm = MatrixUtil.computeNormal(normalMatrix, quad.method_3358());
        for (int i = 0; i < 4; ++i) {
            float fB;
            float fG;
            float fR;
            float x = quadView.getX(i);
            float y = quadView.getY(i);
            float z = quadView.getZ(i);
            float brightness = brightnessTable[i];
            if (colorize) {
                int color = quadView.getColor(i);
                float oR = ColorU8.normalize(ColorABGR.unpackRed(color));
                float oG = ColorU8.normalize(ColorABGR.unpackGreen(color));
                float oB = ColorU8.normalize(ColorABGR.unpackBlue(color));
                fR = oR * brightness * r;
                fG = oG * brightness * g;
                fB = oB * brightness * b;
            } else {
                fR = brightness * r;
                fG = brightness * g;
                fB = brightness * b;
            }
            float u = quadView.getTexU(i);
            float v = quadView.getTexV(i);
            int color = ColorABGR.pack(fR, fG, fB, 1.0f);
            class_1162 pos = new class_1162(x, y, z, 1.0f);
            pos.method_22674(modelMatrix);
            this.vertexQuad(pos.method_4953(), pos.method_4956(), pos.method_4957(), color, u, v, light[i], overlay, norm);
        }
    }

    @Override
    public void vertexGlyph(class_1159 matrix, float x, float y, float z, int color, float u, float v, int light) {
        Matrix4fExtended matrixExt = MatrixUtil.getExtendedMatrix(matrix);
        float x2 = matrixExt.transformVecX(x, y, z);
        float y2 = matrixExt.transformVecY(x, y, z);
        float z2 = matrixExt.transformVecZ(x, y, z);
        if (this.field_1565 != class_290.field_20888) {
            this.vertexGlyphFallback(x2, y2, z2, color, u, v, light);
            return;
        }
        int size = this.field_1565.method_1362();
        this.method_1335(size);
        if (UnsafeUtil.isAvailable()) {
            this.vertexGlyphUnsafe(x2, y2, z2, color, u, v, light);
        } else {
            this.vertexGlyphSafe(x2, y2, z2, color, u, v, light);
        }
        this.field_20884 += size;
        ++this.field_1554;
    }

    private void vertexGlyphFallback(float x, float y, float z, int color, float u, float v, int light) {
        this.method_22912(x, y, z);
        this.method_1336(ColorABGR.unpackRed(color), ColorABGR.unpackGreen(color), ColorABGR.unpackBlue(color), ColorABGR.unpackAlpha(color));
        this.method_22913(u, v);
        this.method_22916(light);
        this.method_1344();
    }

    private void vertexGlyphSafe(float x, float y, float z, int color, float u, float v, int light) {
        int i = this.field_20884;
        ByteBuffer buffer = this.field_1555;
        buffer.putFloat(i, x);
        buffer.putFloat(i += 4, y);
        buffer.putFloat(i += 4, z);
        buffer.putInt(i += 4, color);
        buffer.putFloat(i += 4, u);
        buffer.putFloat(i += 4, v);
        buffer.putInt(i += 4, light);
        i += 4;
    }

    private void vertexGlyphUnsafe(float x, float y, float z, int color, float u, float v, int light) {
        long i = MemoryUtil.memAddress((ByteBuffer)this.field_1555, (int)this.field_20884);
        Unsafe unsafe = UnsafeUtil.instance();
        unsafe.putFloat(i, x);
        unsafe.putFloat(i += 4L, y);
        unsafe.putFloat(i += 4L, z);
        unsafe.putInt(i += 4L, color);
        unsafe.putFloat(i += 4L, u);
        unsafe.putFloat(i += 4L, v);
        unsafe.putInt(i += 4L, light);
        i += 4L;
    }
}

