/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.buffer;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.gl.GlObject;
import me.jellysquid.mods.sodium.client.gl.buffer.VertexData;
import me.jellysquid.mods.sodium.client.gl.func.GlFunctions;
import org.lwjgl.opengl.GL15;

public abstract class GlBuffer
extends GlObject {
    protected int vertexCount = 0;
    protected int size;

    protected GlBuffer() {
        this.setHandle(GL15.glGenBuffers());
    }

    public void unbind(int target) {
        GL15.glBindBuffer((int)target, (int)0);
    }

    public void bind(int target) {
        GL15.glBindBuffer((int)target, (int)this.handle());
    }

    public abstract void upload(int var1, ByteBuffer var2);

    public abstract void allocate(int var1, int var2);

    public void upload(int target, VertexData data) {
        this.vertexCount = data.buffer.remaining() / data.format.getStride();
        this.upload(target, data.buffer);
    }

    public void delete() {
        GL15.glDeleteBuffers((int)this.handle());
        this.invalidateHandle();
        this.size = 0;
    }

    public static void copy(GlBuffer src, GlBuffer dst, int readOffset, int writeOffset, int copyLen, int bufferSize) {
        src.bind(36662);
        dst.bind(36663);
        dst.allocate(36663, bufferSize);
        GlFunctions.BUFFER_COPY.glCopyBufferSubData(36662, 36663, readOffset, writeOffset, copyLen);
        dst.unbind(36663);
        src.unbind(36662);
    }

    public int getSize() {
        return this.size;
    }
}

