/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.util.GlFogHelper;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterator;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import me.jellysquid.mods.sodium.common.util.collections.FutureDequeDrain;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class ChunkRenderManager<T extends ChunkGraphicsState>
implements ChunkStatusListener {
    private static final double NEARBY_CHUNK_DISTANCE = Math.pow(48.0, 2.0);
    private static final float FOG_PLANE_MIN_DISTANCE = (float)Math.pow(8.0, 2.0);
    private static final float FOG_PLANE_OFFSET = 5.0f;
    private final ChunkBuilder<T> builder;
    private final ChunkRenderBackend<T> backend;
    private final Long2ObjectOpenHashMap<ChunkRenderContainer<T>> renders = new Long2ObjectOpenHashMap();
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> iterationQueue = new ObjectArrayFIFOQueue();
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> importantRebuildQueue = new ObjectArrayFIFOQueue();
    private final ObjectArrayFIFOQueue<ChunkRenderContainer<T>> rebuildQueue = new ObjectArrayFIFOQueue();
    private final ChunkRenderList<T>[] chunkRenderLists = new ChunkRenderList[BlockRenderPass.COUNT];
    private final ObjectList<ChunkRenderContainer<T>> tickableChunks = new ObjectArrayList();
    private final ObjectList<class_2586> visibleBlockEntities = new ObjectArrayList();
    private final SodiumWorldRenderer renderer;
    private final class_638 world;
    private final int renderDistance;
    private int lastFrameUpdated;
    private double fogRenderCutoff;
    private boolean useOcclusionCulling;
    private boolean useFogCulling;
    private boolean dirty;
    private double cameraX;
    private double cameraY;
    private double cameraZ;
    private boolean useAggressiveCulling;
    private int visibleChunkCount;

    public ChunkRenderManager(SodiumWorldRenderer renderer, ChunkRenderBackend<T> backend, BlockRenderPassManager renderPassManager, class_638 world, int renderDistance) {
        this.backend = backend;
        this.renderer = renderer;
        this.world = world;
        this.renderDistance = renderDistance;
        this.builder = new ChunkBuilder<T>(backend.getVertexFormat(), this.backend);
        this.builder.init(world, renderPassManager);
        this.dirty = true;
        for (int i = 0; i < this.chunkRenderLists.length; ++i) {
            this.chunkRenderLists[i] = new ChunkRenderList();
        }
    }

    public void updateGraph(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.init(camera, frustum, frame, spectator);
        ObjectArrayFIFOQueue<ChunkRenderContainer<T>> queue = this.iterationQueue;
        while (!queue.isEmpty()) {
            ChunkRenderContainer render = (ChunkRenderContainer)queue.dequeue();
            if (render.needsRebuild() && render.canRebuild()) {
                if (render.needsImportantRebuild()) {
                    this.importantRebuildQueue.enqueue((Object)render);
                } else {
                    this.rebuildQueue.enqueue((Object)render);
                }
            }
            if (!render.isEmpty()) {
                this.addChunkToRenderLists(render);
                Collection<class_2586> blockEntities = render.getData().getBlockEntities();
                if (!blockEntities.isEmpty()) {
                    this.visibleBlockEntities.addAll(blockEntities);
                }
            }
            for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
                if (render.canCull(dir)) continue;
                this.addChunkNeighbor(render, frustum, dir, frame);
            }
        }
        this.dirty = false;
    }

    private void addChunkNeighbor(ChunkRenderContainer<T> parent, FrustumExtended frustum, class_2350 dir, int frame) {
        class_2350 flow;
        ChunkRenderContainer<T> adj = parent.getAdjacentRender(dir);
        if (adj == null || adj.getLastVisibleFrame() == frame) {
            return;
        }
        if (this.useOcclusionCulling && (flow = parent.getDirection()) != null && !parent.isVisibleThrough(flow, dir)) {
            return;
        }
        if (this.useFogCulling && parent.getSquaredDistanceXZ(this.cameraX, this.cameraZ) >= this.fogRenderCutoff) {
            return;
        }
        if (adj.isOutsideFrustum(frustum)) {
            return;
        }
        flow = dir.method_10153();
        adj.setDirection(flow);
        adj.setVisibleFrame(frame);
        adj.setCullingState(parent.getCullingState(), flow);
        this.iterationQueue.enqueue(adj);
    }

    private void addChunkToRenderLists(ChunkRenderContainer<T> render) {
        int visibleFaces = this.computeVisibleFaces(render) & render.getFacesWithData();
        if (visibleFaces == 0) {
            return;
        }
        boolean added = false;
        ChunkGraphicsState[] states = render.getGraphicsStates();
        for (int i = 0; i < states.length; ++i) {
            ChunkGraphicsState state = states[i];
            if (state == null) continue;
            ChunkRenderList<ChunkGraphicsState> list = this.chunkRenderLists[i];
            list.add(state, visibleFaces);
            added = true;
        }
        if (added) {
            if (render.isTickable()) {
                this.tickableChunks.add(render);
            }
            ++this.visibleChunkCount;
        }
    }

    private int computeVisibleFaces(ChunkRenderContainer<T> render) {
        int visibleFaces;
        if (this.useAggressiveCulling) {
            visibleFaces = 1 << ModelQuadFacing.NONE.ordinal();
            ChunkRenderBounds bounds = render.getBounds();
            if (bounds != null) {
                if (this.cameraY > (double)bounds.y1) {
                    visibleFaces |= 1 << ModelQuadFacing.UP.ordinal();
                }
                if (this.cameraY < (double)bounds.y2) {
                    visibleFaces |= 1 << ModelQuadFacing.DOWN.ordinal();
                }
                if (this.cameraX > (double)bounds.x1) {
                    visibleFaces |= 1 << ModelQuadFacing.EAST.ordinal();
                }
                if (this.cameraX < (double)bounds.x2) {
                    visibleFaces |= 1 << ModelQuadFacing.WEST.ordinal();
                }
                if (this.cameraZ > (double)bounds.z1) {
                    visibleFaces |= 1 << ModelQuadFacing.SOUTH.ordinal();
                }
                if (this.cameraZ < (double)bounds.z2) {
                    visibleFaces |= 1 << ModelQuadFacing.NORTH.ordinal();
                }
            }
        } else {
            visibleFaces = 127;
        }
        return visibleFaces;
    }

    private void init(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        float dist;
        this.cameraX = camera.method_19326().field_1352;
        this.cameraY = camera.method_19326().field_1351;
        this.cameraZ = camera.method_19326().field_1350;
        this.lastFrameUpdated = frame;
        this.useOcclusionCulling = class_310.method_1551().field_1730;
        this.useAggressiveCulling = SodiumClientMod.options().advanced.useChunkFaceCulling;
        this.resetGraph();
        class_2338 origin = camera.method_19328();
        int chunkX = origin.method_10263() >> 4;
        int chunkY = origin.method_10264() >> 4;
        int chunkZ = origin.method_10260() >> 4;
        ChunkRenderContainer<T> node = this.getRender(chunkX, chunkY, chunkZ);
        if (node != null) {
            node.resetGraphState();
            node.setVisibleFrame(frame);
            if (spectator && this.world.method_8320(origin).method_26216((class_1922)this.world, origin)) {
                this.useOcclusionCulling = false;
            }
            this.iterationQueue.enqueue(node);
        } else {
            chunkY = class_3532.method_15340((int)(origin.method_10264() >> 4), (int)0, (int)15);
            ArrayList<ChunkRenderContainer> list = new ArrayList<ChunkRenderContainer>();
            for (int x2 = -this.renderDistance; x2 <= this.renderDistance; ++x2) {
                for (int z2 = -this.renderDistance; z2 <= this.renderDistance; ++z2) {
                    ChunkRenderContainer<T> chunk = this.getRender(chunkX + x2, chunkY, chunkZ + z2);
                    if (chunk == null || chunk.isOutsideFrustum(frustum)) continue;
                    chunk.setVisibleFrame(frame);
                    chunk.resetGraphState();
                    list.add(chunk);
                }
            }
            list.sort(Comparator.comparingDouble(o -> o.getSquaredDistance(origin)));
            for (ChunkRenderContainer render : list) {
                this.iterationQueue.enqueue((Object)render);
            }
        }
        this.useFogCulling = false;
        if (SodiumClientMod.options().advanced.useFogOcclusion && (dist = GlFogHelper.getFogCutoff() + 5.0f) != 0.0f) {
            this.useFogCulling = true;
            this.fogRenderCutoff = Math.max(FOG_PLANE_MIN_DISTANCE, dist * dist);
        }
    }

    public ChunkRenderContainer<T> getRender(int x, int y, int z) {
        return (ChunkRenderContainer)this.renders.get(class_4076.method_18685((int)x, (int)y, (int)z));
    }

    private void resetGraph() {
        this.rebuildQueue.clear();
        this.importantRebuildQueue.clear();
        this.visibleBlockEntities.clear();
        for (ChunkRenderList<T> list : this.chunkRenderLists) {
            list.reset();
        }
        this.tickableChunks.clear();
        this.visibleChunkCount = 0;
    }

    public Collection<class_2586> getVisibleBlockEntities() {
        return this.visibleBlockEntities;
    }

    @Override
    public void onChunkAdded(int x, int z) {
        this.builder.onChunkStatusChanged(x, z);
        this.loadChunk(x, z);
    }

    @Override
    public void onChunkRemoved(int x, int z) {
        this.builder.onChunkStatusChanged(x, z);
        this.unloadChunk(x, z);
    }

    private void loadChunk(int x, int z) {
        for (int y = 0; y < 16; ++y) {
            ChunkRenderContainer render = (ChunkRenderContainer)this.renders.computeIfAbsent(class_4076.method_18685((int)x, (int)y, (int)z), this::createChunkRender);
            for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
                ChunkRenderContainer<T> adj = this.getRender(x + dir.method_10148(), y + dir.method_10164(), z + dir.method_10165());
                if (adj == null) continue;
                render.setAdjacentRender(dir, adj);
                adj.setAdjacentRender(dir.method_10153(), render);
            }
        }
        this.dirty = true;
    }

    private void unloadChunk(int x, int z) {
        for (int y = 0; y < 16; ++y) {
            ChunkRenderContainer render = (ChunkRenderContainer)this.renders.remove(class_4076.method_18685((int)x, (int)y, (int)z));
            if (render == null) continue;
            for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
                ChunkRenderContainer adj = render.getAdjacentRender(dir);
                if (adj == null) continue;
                render.setAdjacentRender(dir, adj);
                adj.setAdjacentRender(dir.method_10153(), null);
            }
            render.delete();
        }
        this.dirty = true;
    }

    private ChunkRenderContainer<T> createChunkRender(long pos) {
        int x = class_4076.method_18686((long)pos);
        int y = class_4076.method_18689((long)pos);
        int z = class_4076.method_18690((long)pos);
        ChunkRenderContainer<T> render = new ChunkRenderContainer<T>(this.backend, this.renderer, x, y, z);
        if (class_2826.method_18090((class_2826)this.world.method_8497(x, z).method_12006()[y])) {
            render.setData(ChunkRenderData.EMPTY);
        } else {
            render.scheduleRebuild(false);
        }
        return render;
    }

    public void renderLayer(class_4587 matrixStack, BlockRenderPass pass, double x, double y, double z) {
        ChunkRenderList<T> chunkRenderList = this.chunkRenderLists[pass.ordinal()];
        ChunkRenderListIterator<T> iterator = chunkRenderList.iterator(pass.isTranslucent());
        this.backend.begin(matrixStack);
        this.backend.render(iterator, new ChunkCameraContext(x, y, z));
        this.backend.end(matrixStack);
    }

    public void tickVisibleRenders() {
        for (ChunkRenderContainer render : this.tickableChunks) {
            render.tick();
        }
    }

    public boolean isChunkVisible(int x, int y, int z) {
        ChunkRenderContainer<T> render = this.getRender(x, y, z);
        return render != null && render.getLastVisibleFrame() == this.lastFrameUpdated;
    }

    public void updateChunks() {
        ChunkRenderContainer render;
        ArrayDeque futures = new ArrayDeque();
        int budget = this.builder.getSchedulingBudget();
        int submitted = 0;
        while (!this.importantRebuildQueue.isEmpty()) {
            render = (ChunkRenderContainer)this.importantRebuildQueue.dequeue();
            if (!this.isChunkPrioritized(render)) {
                this.builder.deferRebuild(render);
            } else {
                futures.add(this.builder.scheduleRebuildTaskAsync(render));
            }
            this.dirty = true;
            ++submitted;
        }
        while (submitted < budget && !this.rebuildQueue.isEmpty()) {
            render = (ChunkRenderContainer)this.rebuildQueue.dequeue();
            this.builder.deferRebuild(render);
            ++submitted;
        }
        this.dirty |= submitted > 0;
        this.dirty |= this.builder.performPendingUploads();
        if (!futures.isEmpty()) {
            this.backend.upload(new FutureDequeDrain(futures));
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void restoreChunks(LongCollection chunks) {
        LongIterator it = chunks.iterator();
        while (it.hasNext()) {
            long pos = it.nextLong();
            this.loadChunk(class_1923.method_8325((long)pos), class_1923.method_8332((long)pos));
        }
    }

    public boolean isBuildComplete() {
        return this.builder.isBuildQueueEmpty();
    }

    public void setCameraPosition(double x, double y, double z) {
        this.builder.setCameraPosition(x, y, z);
    }

    public void destroy() {
        this.resetGraph();
        for (ChunkRenderContainer render : this.renders.values()) {
            render.delete();
        }
        this.renders.clear();
        this.builder.stopWorkers();
    }

    public int getTotalSections() {
        return this.renders.size();
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        ChunkRenderContainer<T> render = this.getRender(x, y, z);
        if (render != null) {
            boolean bl = important = important || this.isChunkPrioritized(render);
            if (render.scheduleRebuild(important) && render.getLastVisibleFrame() == this.lastFrameUpdated) {
                (render.needsImportantRebuild() ? this.importantRebuildQueue : this.rebuildQueue).enqueue(render);
            }
            this.dirty = true;
        }
    }

    public boolean isChunkPrioritized(ChunkRenderContainer<T> render) {
        return render.getSquaredDistance(this.cameraX, this.cameraY, this.cameraZ) <= NEARBY_CHUNK_DISTANCE;
    }

    public int getVisibleChunkCount() {
        return this.visibleChunkCount;
    }
}

