/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.gl.SodiumVertexFormats;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadEncoder;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadViewMutable;
import me.jellysquid.mods.sodium.client.model.quad.sink.ModelQuadSink;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import net.minecraft.class_1058;
import net.minecraft.class_311;

public class ChunkMeshBuilder
implements ModelQuadSink {
    private final ModelQuadEncoder encoder;
    private ChunkRenderData.Builder renderData;
    private final int stride;
    private ByteBuffer buffer;
    private int position;
    private int capacity;
    private float x;
    private float y;
    private float z;
    private final float scale;

    public ChunkMeshBuilder(GlVertexFormat<?> format, int initialSize) {
        this.scale = 0.03125f;
        this.stride = format.getStride() * 4;
        this.encoder = SodiumVertexFormats.getEncoder(format);
        this.buffer = class_311.method_1596((int)initialSize);
        this.capacity = initialSize;
    }

    public void begin(ChunkRenderData.Builder renderData) {
        if (this.renderData != null) {
            throw new IllegalStateException("Not finished building!");
        }
        this.renderData = renderData;
    }

    public void setOffset(int x, int y, int z) {
        this.x = (float)x * this.scale;
        this.y = (float)y * this.scale;
        this.z = (float)z * this.scale;
    }

    @Override
    public void write(ModelQuadViewMutable quad) {
        int position = this.position;
        int len = this.stride;
        this.position += len;
        if (this.position >= this.capacity) {
            this.grow(len);
        }
        for (int i = 0; i < 4; ++i) {
            quad.setX(i, quad.getX(i) * this.scale + this.x);
            quad.setY(i, quad.getY(i) * this.scale + this.y);
            quad.setZ(i, quad.getZ(i) * this.scale + this.z);
        }
        this.encoder.write(quad, this.buffer, position);
        class_1058 sprite = quad.getSprite();
        if (sprite != null) {
            this.renderData.addSprite(sprite);
        }
    }

    private void grow(int len) {
        int cap = Math.max(this.capacity * 2, this.capacity + len);
        ByteBuffer buffer = class_311.method_1596((int)cap);
        buffer.put(this.buffer);
        buffer.position(0);
        this.buffer = buffer;
        this.capacity = cap;
    }

    public boolean isEmpty() {
        return this.position <= 0;
    }

    public void sortQuads(float x, float y, float z) {
    }

    public void copyInto(ByteBuffer dst) {
        if (this.renderData != null) {
            throw new IllegalStateException("Not finished building");
        }
        this.buffer.position(0);
        this.buffer.limit(this.position);
        dst.put(this.buffer.slice());
        this.buffer.clear();
        this.position = 0;
    }

    public int getSize() {
        return this.position;
    }

    public void finish() {
        this.renderData = null;
    }
}

