/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import org.lwjgl.opengl.GL11;

public enum ChunkFogMode {
    NONE(ChunkShaderFogComponent.None::new, (List<String>)ImmutableList.of()),
    LINEAR(ChunkShaderFogComponent.Linear::new, (List<String>)ImmutableList.of((Object)"USE_FOG", (Object)"USE_FOG_LINEAR")),
    EXP2(ChunkShaderFogComponent.Exp2::new, (List<String>)ImmutableList.of((Object)"USE_FOG", (Object)"USE_FOG_EXP2"));

    private final Function<ChunkProgram, ChunkShaderFogComponent> factory;
    private final List<String> defines;

    private ChunkFogMode(Function<ChunkProgram, ChunkShaderFogComponent> factory, List<String> defines) {
        this.factory = factory;
        this.defines = defines;
    }

    public Function<ChunkProgram, ChunkShaderFogComponent> getFactory() {
        return this.factory;
    }

    public List<String> getDefines() {
        return this.defines;
    }

    public static ChunkFogMode getActiveMode() {
        if (!GL11.glGetBoolean((int)2912)) {
            return NONE;
        }
        int mode = GL11.glGetInteger((int)2917);
        switch (mode) {
            case 2048: 
            case 2049: {
                return EXP2;
            }
            case 9729: {
                return LINEAR;
            }
        }
        throw new UnsupportedOperationException("Unknown fog mode: " + mode);
    }

    public void addConstants(ShaderConstants.Builder constants) {
        for (String define : this.defines) {
            constants.define(define);
        }
    }
}

