/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.class_1161;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3610;
import net.minecraft.class_4696;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_852;

public class ChunkRenderRebuildTask<T extends ChunkGraphicsState>
extends ChunkRenderBuildTask<T> {
    private final ChunkRenderContainer<T> render;
    private final ChunkBuilder<T> chunkBuilder;
    private final class_1161 camera;
    private final WorldSlice slice;
    private final class_2338 offset;

    public ChunkRenderRebuildTask(ChunkBuilder<T> chunkBuilder, ChunkRenderContainer<T> render, WorldSlice slice, class_2338 offset) {
        this.chunkBuilder = chunkBuilder;
        this.render = render;
        this.camera = chunkBuilder.getCameraPosition();
        this.slice = slice;
        this.offset = offset;
    }

    @Override
    public ChunkBuildResult<T> performBuild(ChunkRenderContext pipeline, ChunkBuildBuffers buffers, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        class_852 occluder = new class_852();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        pipeline.init(this.slice, this.slice.getBlockOffsetX(), this.slice.getBlockOffsetY(), this.slice.getBlockOffsetZ());
        buffers.init(renderData);
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2338 offset = this.offset;
        for (int y = minY; y < maxY; ++y) {
            if (cancellationSource.isCancelled()) {
                return null;
            }
            for (int z = minZ; z < maxZ; ++z) {
                for (int x = minX; x < maxX; ++x) {
                    class_827 renderer;
                    class_2586 entity;
                    class_3610 fluidState;
                    class_2680 blockState = this.slice.getBlockState(x, y, z);
                    class_2248 block = blockState.method_26204();
                    if (blockState.method_26215()) continue;
                    pos.method_10103(x, y, z);
                    if (block.method_9604(blockState) == class_2464.field_11458) {
                        class_1921 layer = class_4696.method_23679((class_2680)blockState);
                        ChunkBuildBuffers.ChunkBuildBufferDelegate builder = buffers.get(layer);
                        builder.setOffset(x - offset.method_10263(), y - offset.method_10264(), z - offset.method_10260());
                        if (pipeline.renderBlock(this.slice, blockState, (class_2338)pos, builder, true)) {
                            bounds.addBlock(x, y, z);
                        }
                    }
                    if (!(fluidState = block.method_9545(blockState)).method_15769()) {
                        class_1921 layer = class_4696.method_23680((class_3610)fluidState);
                        ChunkBuildBuffers.ChunkBuildBufferDelegate builder = buffers.get(layer);
                        builder.setOffset(x - offset.method_10263(), y - offset.method_10264(), z - offset.method_10260());
                        if (pipeline.renderFluid(this.slice, fluidState, pos, builder)) {
                            bounds.addBlock(x, y, z);
                        }
                    }
                    if (block.method_26161() && (entity = this.slice.getBlockEntity((class_2338)pos, class_2818.class_2819.field_12859)) != null && (renderer = class_824.field_4346.method_3550(entity)) != null) {
                        renderData.addBlockEntity(entity, !renderer.method_3563(entity));
                        bounds.addBlock(x, y, z);
                    }
                    if (!blockState.method_26216((class_1922)this.slice, (class_2338)pos)) continue;
                    occluder.method_3682((class_2338)pos);
                }
            }
        }
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            ChunkMeshData mesh = buffers.createMesh(this.camera, this.render.getRenderOrigin(), pass);
            if (mesh == null) continue;
            renderData.setMesh(pass, mesh);
        }
        renderData.setOcclusionData(occluder.method_3679());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        return new ChunkBuildResult<T>(this.render, renderData.build());
    }

    @Override
    public void releaseResources() {
        this.chunkBuilder.releaseWorldSlice(this.slice);
    }
}

