/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuad;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.model.quad.sink.ModelQuadSinkDelegate;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_777;

public class BlockRenderer {
    private final Random random = new XoRoShiRoRandom();
    private final BlockColorsExtended blockColors;
    private final BlockOcclusionCache occlusionCache;
    private final ModelQuad cachedQuad = new ModelQuad();
    private final QuadLightData cachedQuadLightData = new QuadLightData();
    private final BiomeColorBlender biomeColorBlender;
    private final LightPipelineProvider lighters;
    private final boolean useAmbientOcclusion;

    public BlockRenderer(class_310 client, LightPipelineProvider lighters, BiomeColorBlender biomeColorBlender) {
        this.blockColors = (BlockColorsExtended)client.method_1505();
        this.biomeColorBlender = biomeColorBlender;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = class_310.method_1588();
    }

    public boolean renderModel(class_1920 world, class_2680 state, class_2338 pos, class_1087 model, ModelQuadSinkDelegate builder, boolean cull, long seed) {
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(state, model));
        class_243 offset = state.method_26226((class_1922)world, pos);
        boolean rendered = false;
        for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
            this.random.setSeed(seed);
            List sided = model.method_4707(state, dir, this.random);
            if (sided.isEmpty() || cull && !this.occlusionCache.shouldDrawSide(state, (class_1922)world, pos, dir)) continue;
            this.renderQuadList(world, state, pos, lighter, offset, builder, sided, ModelQuadFacing.fromDirection(dir));
            rendered = true;
        }
        this.random.setSeed(seed);
        List all = model.method_4707(state, null, this.random);
        if (!all.isEmpty()) {
            this.renderQuadList(world, state, pos, lighter, offset, builder, all, ModelQuadFacing.NONE);
            rendered = true;
        }
        return rendered;
    }

    private void renderQuadList(class_1920 world, class_2680 state, class_2338 pos, LightPipeline lighter, class_243 offset, ModelQuadSinkDelegate builder, List<class_777> quads, ModelQuadFacing facing) {
        class_322 colorizer = null;
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            class_777 quad = quads.get(i);
            QuadLightData light = this.cachedQuadLightData;
            lighter.calculate((ModelQuadView)quad, pos, light, quad.method_3358(), quad.method_24874());
            if (quad.method_3360() && colorizer == null) {
                colorizer = this.blockColors.getColorProvider(state);
            }
            this.renderQuad(world, state, pos, builder, offset, colorizer, quad, light, facing);
        }
    }

    private void renderQuad(class_1920 world, class_2680 state, class_2338 pos, ModelQuadSinkDelegate consumer, class_243 offset, class_322 colorProvider, class_777 bakedQuad, QuadLightData light, ModelQuadFacing facing) {
        ModelQuadView src = (ModelQuadView)bakedQuad;
        ModelQuadOrientation order = ModelQuadOrientation.orient(light.br);
        ModelQuad copy = this.cachedQuad;
        int norm = ModelQuadUtil.getFacingNormal(bakedQuad.method_3358());
        int[] colors = null;
        if (bakedQuad.method_3360()) {
            colors = this.biomeColorBlender.getColors(colorProvider, world, state, pos, src);
        }
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = order.getVertexIndex(dstIndex);
            copy.setX(dstIndex, src.getX(srcIndex) + (float)offset.method_10216());
            copy.setY(dstIndex, src.getY(srcIndex) + (float)offset.method_10214());
            copy.setZ(dstIndex, src.getZ(srcIndex) + (float)offset.method_10215());
            copy.setColor(dstIndex, ColorABGR.mul(colors != null ? colors[srcIndex] : -1, light.br[srcIndex]));
            copy.setTexU(dstIndex, src.getTexU(srcIndex));
            copy.setTexV(dstIndex, src.getTexV(srcIndex));
            copy.setLight(dstIndex, light.lm[srcIndex]);
            copy.setNormal(dstIndex, norm);
            copy.setSprite(src.getSprite());
        }
        consumer.get(facing).write(copy);
    }

    private LightMode getLightingMode(class_2680 state, class_1087 model) {
        if (this.useAmbientOcclusion && model.method_4708() && state.method_26213() == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

