/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuad;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadViewMutable;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.sink.ModelQuadSinkDelegate;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.class_1058;
import net.minecraft.class_1088;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2506;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_773;

public class FluidRenderer {
    private static final class_322 FLUID_COLOR_PROVIDER = (state, world, pos, tintIndex) -> {
        if (world == null) {
            return -1;
        }
        return class_1163.method_4961((class_1920)world, (class_2338)pos);
    };
    private final class_2338.class_2339 scratchPos = new class_2338.class_2339();
    private final class_1058[] lavaSprites = new class_1058[2];
    private final class_1058[] waterSprites = new class_1058[2];
    private final class_1058 waterOverlaySprite;
    private final ModelQuadViewMutable quad = new ModelQuad();
    private final LightPipelineProvider lighters;
    private final BiomeColorBlender biomeColorBlender;
    private final QuadLightData quadLightData = new QuadLightData();
    private final int[] quadColors = new int[4];

    public FluidRenderer(class_310 client, LightPipelineProvider lighters, BiomeColorBlender biomeColorBlender) {
        class_773 models = client.method_1554().method_4743();
        this.lavaSprites[0] = models.method_3335(class_2246.field_10164.method_9564()).method_4711();
        this.lavaSprites[1] = class_1088.field_5381.method_24148();
        this.waterSprites[0] = models.method_3335(class_2246.field_10382.method_9564()).method_4711();
        this.waterSprites[1] = class_1088.field_5391.method_24148();
        this.waterOverlaySprite = class_1088.field_5388.method_24148();
        int normal = Norm3b.pack(0.0f, 1.0f, 0.0f);
        for (int i = 0; i < 4; ++i) {
            this.quad.setNormal(i, normal);
        }
        this.lighters = lighters;
        this.biomeColorBlender = biomeColorBlender;
    }

    private boolean isFluidExposed(class_1920 world, int x, int y, int z, class_3611 fluid) {
        class_2338.class_2339 pos = this.scratchPos.method_10103(x, y, z);
        return !world.method_8316((class_2338)pos).method_15772().method_15780(fluid);
    }

    private boolean isSideExposed(class_1920 world, int x, int y, int z, class_2350 dir, float height) {
        class_2338.class_2339 pos = this.scratchPos.method_10103(x + dir.method_10148(), y + dir.method_10164(), z + dir.method_10165());
        class_2680 blockState = world.method_8320((class_2338)pos);
        if (blockState.method_26225()) {
            class_265 shape = blockState.method_26201((class_1922)world, (class_2338)pos);
            if (shape == class_259.method_1077()) {
                return dir == class_2350.field_11036;
            }
            if (shape.method_1110()) {
                return true;
            }
            class_265 threshold = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)height, (double)1.0);
            return !class_259.method_1083((class_265)threshold, (class_265)shape, (class_2350)dir);
        }
        return true;
    }

    public boolean render(class_1920 world, class_3610 fluidState, class_2338 pos, ModelQuadSinkDelegate consumer) {
        int posX = pos.method_10263();
        int posY = pos.method_10264();
        int posZ = pos.method_10260();
        class_3611 fluid = fluidState.method_15772();
        boolean sfUp = this.isFluidExposed(world, posX, posY + 1, posZ, fluid);
        boolean sfDown = this.isFluidExposed(world, posX, posY - 1, posZ, fluid) && this.isSideExposed(world, posX, posY, posZ, class_2350.field_11033, 0.8888889f);
        boolean sfNorth = this.isFluidExposed(world, posX, posY, posZ - 1, fluid);
        boolean sfSouth = this.isFluidExposed(world, posX, posY, posZ + 1, fluid);
        boolean sfWest = this.isFluidExposed(world, posX - 1, posY, posZ, fluid);
        boolean sfEast = this.isFluidExposed(world, posX + 1, posY, posZ, fluid);
        if (!(sfUp || sfDown || sfEast || sfWest || sfNorth || sfSouth)) {
            return false;
        }
        boolean lava = fluidState.method_15767((class_3494)class_3486.field_15518);
        class_1058[] sprites = lava ? this.lavaSprites : this.waterSprites;
        boolean rendered = false;
        float h1 = this.getCornerHeight(world, posX, posY, posZ, fluidState.method_15772());
        float h2 = this.getCornerHeight(world, posX, posY, posZ + 1, fluidState.method_15772());
        float h3 = this.getCornerHeight(world, posX + 1, posY, posZ + 1, fluidState.method_15772());
        float h4 = this.getCornerHeight(world, posX + 1, posY, posZ, fluidState.method_15772());
        float yOffset = sfDown ? 0.001f : 0.0f;
        ModelQuadViewMutable quad = this.quad;
        QuadLightData light = this.quadLightData;
        LightMode lightMode = !lava && class_310.method_1588() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        quad.setFlags(0);
        if (sfUp && this.isSideExposed(world, posX, posY, posZ, class_2350.field_11036, Math.min(Math.min(h1, h2), Math.min(h3, h4)))) {
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            class_1058 sprite;
            h1 -= 0.001f;
            h2 -= 0.001f;
            h3 -= 0.001f;
            h4 -= 0.001f;
            class_243 velocity = fluidState.method_15758((class_1922)world, pos);
            if (velocity.field_1352 == 0.0 && velocity.field_1350 == 0.0) {
                sprite = sprites[0];
                u1 = sprite.method_4580(0.0);
                v1 = sprite.method_4570(0.0);
                u2 = u1;
                v2 = sprite.method_4570(16.0);
                u3 = sprite.method_4580(16.0);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                sprite = sprites[1];
                float dir = (float)class_3532.method_15349((double)velocity.field_1350, (double)velocity.field_1352) - 1.5707964f;
                float sin = class_3532.method_15374((float)dir) * 0.25f;
                float cos = class_3532.method_15362((float)dir) * 0.25f;
                u1 = sprite.method_4580((double)(8.0f + (-cos - sin) * 16.0f));
                v1 = sprite.method_4570((double)(8.0f + (-cos + sin) * 16.0f));
                u2 = sprite.method_4580((double)(8.0f + (-cos + sin) * 16.0f));
                v2 = sprite.method_4570((double)(8.0f + (cos + sin) * 16.0f));
                u3 = sprite.method_4580((double)(8.0f + (cos + sin) * 16.0f));
                v3 = sprite.method_4570((double)(8.0f + (cos - sin) * 16.0f));
                u4 = sprite.method_4580((double)(8.0f + (cos - sin) * 16.0f));
                v4 = sprite.method_4570((double)(8.0f + (-cos - sin) * 16.0f));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s1 = (float)sprites[0].method_4578() / (sprites[0].method_4577() - sprites[0].method_4594());
            float s2 = (float)sprites[0].method_4595() / (sprites[0].method_4575() - sprites[0].method_4593());
            float s3 = 4.0f / Math.max(s2, s1);
            u1 = class_3532.method_16439((float)s3, (float)u1, (float)uAvg);
            u2 = class_3532.method_16439((float)s3, (float)u2, (float)uAvg);
            u3 = class_3532.method_16439((float)s3, (float)u3, (float)uAvg);
            u4 = class_3532.method_16439((float)s3, (float)u4, (float)uAvg);
            v1 = class_3532.method_16439((float)s3, (float)v1, (float)vAvg);
            v2 = class_3532.method_16439((float)s3, (float)v2, (float)vAvg);
            v3 = class_3532.method_16439((float)s3, (float)v3, (float)vAvg);
            v4 = class_3532.method_16439((float)s3, (float)v4, (float)vAvg);
            quad.setSprite(sprite);
            this.setVertex(quad, 0, 0.0f, 0.0f + h1, 0.0f, u1, v1);
            this.setVertex(quad, 1, 0.0f, 0.0f + h2, 1.0f, u2, v2);
            this.setVertex(quad, 2, 1.0f, 0.0f + h3, 1.0f, u3, v3);
            this.setVertex(quad, 3, 1.0f, 0.0f + h4, 0.0f, u4, v4);
            this.calculateQuadColors(quad, world, pos, lighter, class_2350.field_11036, 1.0f, !lava);
            this.flushQuad(consumer, quad, class_2350.field_11036, false);
            if (fluidState.method_15756((class_1922)world, (class_2338)this.scratchPos.method_10103(posX, posY + 1, posZ))) {
                this.setVertex(quad, 3, 0.0f, 0.0f + h1, 0.0f, u1, v1);
                this.setVertex(quad, 2, 0.0f, 0.0f + h2, 1.0f, u2, v2);
                this.setVertex(quad, 1, 1.0f, 0.0f + h3, 1.0f, u3, v3);
                this.setVertex(quad, 0, 1.0f, 0.0f + h4, 0.0f, u4, v4);
                this.flushQuad(consumer, quad, class_2350.field_11033, true);
            }
            rendered = true;
        }
        if (sfDown) {
            class_1058 sprite = sprites[0];
            float minU = sprite.method_4594();
            float maxU = sprite.method_4577();
            float minV = sprite.method_4593();
            float maxV = sprite.method_4575();
            quad.setSprite(sprite);
            this.setVertex(quad, 0, 0.0f, 0.0f + yOffset, 1.0f, minU, maxV);
            this.setVertex(quad, 1, 0.0f, 0.0f + yOffset, 0.0f, minU, minV);
            this.setVertex(quad, 2, 1.0f, 0.0f + yOffset, 0.0f, maxU, minV);
            this.setVertex(quad, 3, 1.0f, 0.0f + yOffset, 1.0f, maxU, maxV);
            this.calculateQuadColors(quad, world, pos, lighter, class_2350.field_11033, 1.0f, !lava);
            this.flushQuad(consumer, quad, class_2350.field_11033, false);
            rendered = true;
        }
        this.quad.setFlags(1);
        block6: for (class_2350 dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            class_2338.class_2339 posAdj;
            class_2248 block;
            float z2;
            float z1;
            float x2;
            float x1;
            float c2;
            float c1;
            switch (dir) {
                case field_11043: {
                    if (!sfNorth) continue block6;
                    c1 = h1;
                    c2 = h4;
                    x1 = 0.0f;
                    x2 = 1.0f;
                    z2 = z1 = 0.001f;
                    break;
                }
                case field_11035: {
                    if (!sfSouth) continue block6;
                    c1 = h3;
                    c2 = h2;
                    x1 = 1.0f;
                    x2 = 0.0f;
                    z2 = z1 = 0.999f;
                    break;
                }
                case field_11039: {
                    if (!sfWest) continue block6;
                    c1 = h2;
                    c2 = h1;
                    x2 = x1 = 0.001f;
                    z1 = 1.0f;
                    z2 = 0.0f;
                    break;
                }
                case field_11034: {
                    if (!sfEast) continue block6;
                    c1 = h4;
                    c2 = h3;
                    x2 = x1 = 0.999f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (!this.isSideExposed(world, posX, posY, posZ, dir, Math.max(c1, c2))) continue;
            int adjX = posX + dir.method_10148();
            int adjY = posY + dir.method_10164();
            int adjZ = posZ + dir.method_10165();
            class_1058 sprite = sprites[1];
            if (!lava && ((block = world.method_8320((class_2338)(posAdj = this.scratchPos.method_10103(adjX, adjY, adjZ))).method_26204()) == class_2246.field_10033 || block instanceof class_2506)) {
                sprite = this.waterOverlaySprite;
            }
            float u1 = sprite.method_4580(0.0);
            float u2 = sprite.method_4580(8.0);
            float v1 = sprite.method_4570((double)((1.0f - c1) * 16.0f * 0.5f));
            float v2 = sprite.method_4570((double)((1.0f - c2) * 16.0f * 0.5f));
            float v3 = sprite.method_4570(8.0);
            quad.setSprite(sprite);
            this.setVertex(quad, 0, x2, 0.0f + c2, z2, u2, v2);
            this.setVertex(quad, 1, x2, 0.0f + yOffset, z2, u2, v3);
            this.setVertex(quad, 2, x1, 0.0f + yOffset, z1, u1, v3);
            this.setVertex(quad, 3, x1, 0.0f + c1, z1, u1, v1);
            float br = dir.method_10166() == class_2350.class_2351.field_11051 ? 0.8f : 0.6f;
            this.calculateQuadColors(quad, world, pos, lighter, dir, br, !lava);
            this.flushQuad(consumer, quad, dir, false);
            if (sprite != this.waterOverlaySprite) {
                this.setVertex(quad, 0, x1, 0.0f + c1, z1, u1, v1);
                this.setVertex(quad, 1, x1, 0.0f + yOffset, z1, u1, v3);
                this.setVertex(quad, 2, x2, 0.0f + yOffset, z2, u2, v3);
                this.setVertex(quad, 3, x2, 0.0f + c2, z2, u2, v2);
                this.flushQuad(consumer, quad, dir, true);
            }
            rendered = true;
        }
        return rendered;
    }

    private void calculateQuadColors(ModelQuadViewMutable quad, class_1920 world, class_2338 pos, LightPipeline lighter, class_2350 dir, float brightness, boolean colorized) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, pos, light, dir, false);
        int[] biomeColors = null;
        if (colorized) {
            biomeColors = this.biomeColorBlender.getColors(FLUID_COLOR_PROVIDER, world, class_2246.field_10382.method_9564(), pos, quad);
        }
        for (int i = 0; i < 4; ++i) {
            this.quadColors[i] = ColorABGR.mul(biomeColors != null ? biomeColors[i] : -1, light.br[i] * brightness);
        }
    }

    private void flushQuad(ModelQuadSinkDelegate consumer, ModelQuadViewMutable quad, class_2350 dir, boolean flip) {
        int lightOrder;
        int vertexIdx;
        if (flip) {
            vertexIdx = 3;
            lightOrder = -1;
        } else {
            vertexIdx = 0;
            lightOrder = 1;
        }
        for (int i = 0; i < 4; ++i) {
            quad.setColor(i, this.quadColors[vertexIdx]);
            quad.setLight(i, this.quadLightData.lm[vertexIdx]);
            vertexIdx += lightOrder;
        }
        consumer.get(ModelQuadFacing.fromDirection(dir)).write(quad);
    }

    private void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
        quad.setX(i, x);
        quad.setY(i, y);
        quad.setZ(i, z);
        quad.setTexU(i, u);
        quad.setTexV(i, v);
    }

    private float getCornerHeight(class_1920 world, int x, int y, int z, class_3611 fluid) {
        int samples = 0;
        float totalHeight = 0.0f;
        for (int i = 0; i < 4; ++i) {
            int x2 = x - (i & 1);
            int z2 = z - (i >> 1 & 1);
            if (world.method_8316((class_2338)this.scratchPos.method_10103(x2, y + 1, z2)).method_15772().method_15780(fluid)) {
                return 1.0f;
            }
            class_2338.class_2339 pos = this.scratchPos.method_10103(x2, y, z2);
            class_2680 blockState = world.method_8320((class_2338)pos);
            class_3610 fluidState = blockState.method_26227();
            if (fluidState.method_15772().method_15780(fluid)) {
                float height = fluidState.method_15763((class_1922)world, (class_2338)pos);
                if (height >= 0.8f) {
                    totalHeight += height * 10.0f;
                    samples += 10;
                    continue;
                }
                totalHeight += height;
                ++samples;
                continue;
            }
            if (blockState.method_26207().method_15799()) continue;
            ++samples;
        }
        return totalHeight / (float)samples;
    }
}

