/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.concurrent.locks.StampedLock;
import me.jellysquid.mods.sodium.client.util.collections.FixedLongHashTable;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListenerManager;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2806;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_4548;
import net.minecraft.class_631;
import net.minecraft.class_638;

public class SodiumChunkManager
extends class_631
implements ChunkStatusListenerManager {
    private final class_638 world;
    private final class_2818 emptyChunk;
    private final StampedLock lock = new StampedLock();
    private FixedLongHashTable<class_2818> chunks;
    private ChunkStatusListener listener;
    private int centerX;
    private int centerZ;
    private int radius;

    public SodiumChunkManager(class_638 world, int loadDistance) {
        super(world, loadDistance);
        this.world = world;
        this.emptyChunk = new class_2812((class_1937)world, new class_1923(0, 0));
        this.radius = SodiumChunkManager.getChunkMapRadius(loadDistance);
        this.chunks = new FixedLongHashTable(SodiumChunkManager.getChunkMapSize(this.radius), 0.5f);
    }

    public void method_2859(int x, int z) {
        if (this.chunks.remove(SodiumChunkManager.createChunkKey(x, z)) != null) {
            this.onChunkUnloaded(x, z);
        }
    }

    public class_2818 method_2857(int x, int z, class_2806 status, boolean create) {
        class_2818 chunk = this.getChunkSafe(SodiumChunkManager.createChunkKey(x, z));
        if (chunk == null) {
            return create ? this.emptyChunk : null;
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private class_2818 getChunkSafe(long key) {
        long stamp = this.lock.tryOptimisticRead();
        class_2818 chunk = this.chunks.get(key);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                chunk = this.chunks.get(key);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_2818 method_16020(int x, int z, class_4548 biomes, class_2540 buf, class_2487 tag, int verticalStripBitmask, boolean complete) {
        long key = SodiumChunkManager.createChunkKey(x, z);
        class_2818 chunk = this.chunks.get(key);
        if (!complete && chunk != null) {
            chunk.method_12224(biomes, buf, tag, verticalStripBitmask);
        } else {
            if (biomes == null) {
                return null;
            }
            chunk = new class_2818((class_1937)this.world, new class_1923(x, z), biomes);
            chunk.method_12224(biomes, buf, tag, verticalStripBitmask);
            long stamp = this.lock.writeLock();
            try {
                this.chunks.put(key, chunk);
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }
        this.onChunkLoaded(x, z, chunk);
        return chunk;
    }

    public void method_20317(int x, int z) {
        this.centerX = x;
        this.centerZ = z;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_20180(int loadDistance) {
        this.radius = SodiumChunkManager.getChunkMapRadius(loadDistance);
        FixedLongHashTable<Object> copy = new FixedLongHashTable<Object>(SodiumChunkManager.getChunkMapSize(this.radius), 0.5f);
        long stamp = this.lock.writeLock();
        try {
            ObjectIterator<Long2ObjectMap.Entry<class_2818>> it = this.chunks.iterator();
            while (it.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
                long pos = entry.getLongKey();
                int x = class_1923.method_8325((long)pos);
                int z = class_1923.method_8332((long)pos);
                if (Math.abs(x - this.centerX) > this.radius || Math.abs(z - this.centerZ) > this.radius) continue;
                copy.put(pos, entry.getValue());
            }
            this.chunks = copy;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public String method_12122() {
        return "SodiumChunkCache: " + this.method_20182();
    }

    public int method_20182() {
        return this.chunks.size();
    }

    @Override
    public void setListener(ChunkStatusListener listener) {
        this.listener = listener;
    }

    private void onChunkLoaded(int x, int z, class_2818 chunk) {
        class_3568 lightEngine = this.method_12130();
        lightEngine.method_15557(new class_1923(x, z), true);
        class_2826[] sections = chunk.method_12006();
        for (int y = 0; y < sections.length; ++y) {
            lightEngine.method_15551(class_4076.method_18676((int)x, (int)y, (int)z), class_2826.method_18090((class_2826)sections[y]));
        }
        this.world.method_23782(x, z);
        if (this.listener != null) {
            this.listener.onChunkAdded(x, z);
        }
    }

    private void onChunkUnloaded(int x, int z) {
        if (this.listener != null) {
            this.listener.onChunkRemoved(x, z);
        }
    }

    private static long createChunkKey(int x, int z) {
        return class_1923.method_8331((int)x, (int)z);
    }

    private static int getChunkMapRadius(int radius) {
        return Math.max(2, radius) + 3;
    }

    private static int getChunkMapSize(int radius) {
        int n = radius * 2 + 1;
        return n * n;
    }
}

