/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.world.biome.BiomeCache;
import me.jellysquid.mods.sodium.client.world.biome.BiomeCacheManager;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorCache;
import me.jellysquid.mods.sodium.common.util.pool.ReusableObject;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2804;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3532;
import net.minecraft.class_3562;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4543;
import net.minecraft.class_4548;
import net.minecraft.world.level.ColorResolver;

public class WorldSlice
extends ReusableObject
implements class_1920,
class_4543.class_4544 {
    public static final int NEIGHBOR_BLOCK_RADIUS = 1;
    public static final int NEIGHBOR_CHUNK_RADIUS = class_3532.method_28139((int)1, (int)16) >> 4;
    public static final int SECTION_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    public static final int BLOCK_LENGTH = 18;
    public static final int BLOCK_COUNT = 5832;
    public static final int SECTION_COUNT = SECTION_LENGTH * SECTION_LENGTH * SECTION_LENGTH;
    public static final int CHUNK_COUNT = SECTION_LENGTH * SECTION_LENGTH;
    private static final class_2826 EMPTY_SECTION = new class_2826(0);
    private final class_2680[] blockStates;
    private final class_2804[] blockLightArrays;
    private final class_2804[] skyLightArrays;
    private final BiomeCache[] biomeCaches;
    private final class_4548[] biomeArrays;
    private final Map<ColorResolver, BiomeColorCache> colorResolvers = new Reference2ObjectOpenHashMap();
    private ColorResolver prevColorResolver;
    private BiomeColorCache prevColorCache;
    private class_1937 world;
    private class_2818[] chunks;
    private BiomeCacheManager biomeCacheManager;
    private int chunkOffsetX;
    private int chunkOffsetY;
    private int chunkOffsetZ;
    private int blockOffsetX;
    private int blockOffsetY;
    private int blockOffsetZ;

    public static class_2818[] createChunkSlice(class_1937 world, class_4076 pos) {
        class_2818 chunk = world.method_8497(pos.method_10263(), pos.method_10260());
        class_2826 section = chunk.method_12006()[pos.method_10264()];
        if (section == null || section.method_12261()) {
            return null;
        }
        int minChunkX = pos.method_10263() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = pos.method_10260() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = pos.method_10263() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = pos.method_10260() + NEIGHBOR_CHUNK_RADIUS;
        class_2818[] chunks = new class_2818[SECTION_LENGTH * SECTION_LENGTH];
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                chunks[WorldSlice.getLocalChunkIndex((int)(x - minChunkX), (int)(z - minChunkZ))] = world.method_8497(x, z);
            }
        }
        return chunks;
    }

    public WorldSlice() {
        this.blockStates = new class_2680[5832];
        this.blockLightArrays = new class_2804[SECTION_COUNT];
        this.skyLightArrays = new class_2804[SECTION_COUNT];
        this.biomeCaches = new BiomeCache[CHUNK_COUNT];
        this.biomeArrays = new class_4548[CHUNK_COUNT];
    }

    public void init(ChunkBuilder<?> builder, class_1937 world, class_4076 chunkPos, class_2818[] chunks) {
        int minX = chunkPos.method_19527() - 1;
        int minY = chunkPos.method_19528() - 1;
        int minZ = chunkPos.method_19529() - 1;
        int maxX = chunkPos.method_19530() + 1 + 1;
        int maxY = chunkPos.method_19531() + 1 + 1;
        int maxZ = chunkPos.method_19532() + 1 + 1;
        int minChunkX = minX >> 4;
        int maxChunkX = maxX >> 4;
        int minChunkY = minY >> 4;
        int maxChunkY = maxY >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkZ = maxZ >> 4;
        this.world = world;
        this.chunks = chunks;
        this.blockOffsetX = minX;
        this.blockOffsetY = minY;
        this.blockOffsetZ = minZ;
        this.chunkOffsetX = chunkPos.method_10263() - NEIGHBOR_CHUNK_RADIUS;
        this.chunkOffsetY = chunkPos.method_10264() - NEIGHBOR_CHUNK_RADIUS;
        this.chunkOffsetZ = chunkPos.method_10260() - NEIGHBOR_CHUNK_RADIUS;
        class_3562 blockLightProvider = this.world.method_22336().method_15562(class_1944.field_9282);
        class_3562 skyLightProvider = this.world.method_22336().method_15562(class_1944.field_9284);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int chunkXLocal = chunkX - this.chunkOffsetX;
                int chunkZLocal = chunkZ - this.chunkOffsetZ;
                int chunkIdx = WorldSlice.getLocalChunkIndex(chunkXLocal, chunkZLocal);
                class_2818 chunk = chunks[chunkIdx];
                this.biomeArrays[chunkIdx] = chunk.method_12036();
                int minBlockX = Math.max(minX, chunkX << 4);
                int maxBlockX = Math.min(maxX, chunkX + 1 << 4);
                int minBlockZ = Math.max(minZ, chunkZ << 4);
                int maxBlockZ = Math.min(maxZ, chunkZ + 1 << 4);
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    int chunkYLocal = chunkY - this.chunkOffsetY;
                    class_4076 sectionPos = class_4076.method_18676((int)chunkX, (int)chunkY, (int)chunkZ);
                    int sectionIdx = WorldSlice.getLocalSectionIndex(chunkXLocal, chunkYLocal, chunkZLocal);
                    this.blockLightArrays[sectionIdx] = blockLightProvider.method_15544(sectionPos);
                    this.skyLightArrays[sectionIdx] = skyLightProvider.method_15544(sectionPos);
                    class_2826 section = null;
                    if (chunkY >= 0 && chunkY < 16) {
                        section = chunk.method_12006()[chunkY];
                    }
                    if (section == null) {
                        section = EMPTY_SECTION;
                    }
                    int minBlockY = Math.max(minY, chunkY << 4);
                    int maxBlockY = Math.min(maxY, chunkY + 1 << 4);
                    for (int y = minBlockY; y < maxBlockY; ++y) {
                        for (int z = minBlockZ; z < maxBlockZ; ++z) {
                            for (int x = minBlockX; x < maxBlockX; ++x) {
                                this.blockStates[this.getBlockIndex((int)x, (int)y, (int)z)] = section.method_12254(x & 0xF, y & 0xF, z & 0xF);
                            }
                        }
                    }
                }
            }
        }
        this.biomeCacheManager = builder.getBiomeCacheManager();
        this.biomeCacheManager.populateArrays(chunkPos.method_10263(), chunkPos.method_10264(), chunkPos.method_10260(), this.biomeCaches);
    }

    public class_2680 method_8320(class_2338 pos) {
        return this.blockStates[this.getBlockIndex(pos.method_10263(), pos.method_10264(), pos.method_10260())];
    }

    public class_2680 getBlockState(int x, int y, int z) {
        return this.blockStates[this.getBlockIndex(x, y, z)];
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    public class_3610 getFluidState(int x, int y, int z) {
        return this.getBlockState(x, y, z).method_26227();
    }

    public float method_24852(class_2350 direction, boolean shaded) {
        return this.world.method_24852(direction, shaded);
    }

    public class_3568 method_22336() {
        return this.world.method_22336();
    }

    public class_2586 method_8321(class_2338 pos) {
        return this.getBlockEntity(pos, class_2818.class_2819.field_12860);
    }

    public class_2586 getBlockEntity(class_2338 pos, class_2818.class_2819 type) {
        return this.chunks[this.getChunkIndexForBlock(pos)].method_12201(pos, type);
    }

    public int method_23752(class_2338 pos, ColorResolver resolver) {
        BiomeColorCache cache;
        if (this.prevColorResolver == resolver) {
            cache = this.prevColorCache;
        } else {
            cache = this.colorResolvers.get(resolver);
            if (cache == null) {
                cache = new BiomeColorCache(resolver, this);
                this.colorResolvers.put(resolver, cache);
            }
            this.prevColorResolver = resolver;
            this.prevColorCache = cache;
        }
        return cache.getBlendedColor(pos);
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        switch (type) {
            case field_9284: {
                return this.getLightLevel(this.skyLightArrays, pos);
            }
            case field_9282: {
                return this.getLightLevel(this.blockLightArrays, pos);
            }
        }
        return 0;
    }

    public int method_22335(class_2338 pos, int ambientDarkness) {
        return 0;
    }

    public boolean method_8311(class_2338 pos) {
        return false;
    }

    private int getLightLevel(class_2804[] arrays, class_2338 pos) {
        int z;
        int y;
        int x = pos.method_10263();
        class_2804 array = arrays[this.getSectionIndexForBlock(x, y = pos.method_10264(), z = pos.method_10260())];
        if (array != null) {
            return array.method_12139(x & 0xF, y & 0xF, z & 0xF);
        }
        return 0;
    }

    public class_1959 method_16359(int x, int y, int z) {
        class_4548 array = this.biomeArrays[this.getBiomeIndexForBlock(x, z)];
        if (array != null) {
            return array.method_16359(x, y, z);
        }
        return this.world.method_22387(x, y, z);
    }

    public class_1959 getCachedBiome(int x, int z) {
        return this.biomeCaches[this.getChunkIndexForBlock(x, z)].getBiome(this, x, z);
    }

    private int getBlockIndex(int x, int y, int z) {
        int x2 = x - this.blockOffsetX;
        int y2 = y - this.blockOffsetY;
        int z2 = z - this.blockOffsetZ;
        return y2 * 18 * 18 + z2 * 18 + x2;
    }

    private int getChunkIndexForBlock(class_2338 pos) {
        return this.getChunkIndexForBlock(pos.method_10263(), pos.method_10260());
    }

    private int getChunkIndexForBlock(int x, int z) {
        int x2 = (x >> 4) - this.chunkOffsetX;
        int z2 = (z >> 4) - this.chunkOffsetZ;
        return WorldSlice.getLocalChunkIndex(x2, z2);
    }

    private int getBiomeIndexForBlock(int x, int z) {
        int x2 = (x >> 2) - this.chunkOffsetX;
        int z2 = (z >> 2) - this.chunkOffsetZ;
        return WorldSlice.getLocalChunkIndex(x2, z2);
    }

    private int getSectionIndexForBlock(int x, int y, int z) {
        int x2 = (x >> 4) - this.chunkOffsetX;
        int y2 = (y >> 4) - this.chunkOffsetY;
        int z2 = (z >> 4) - this.chunkOffsetZ;
        return WorldSlice.getLocalSectionIndex(x2, y2, z2);
    }

    public static int getLocalChunkIndex(int x, int z) {
        return z * SECTION_LENGTH + x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y * SECTION_LENGTH * SECTION_LENGTH + z * SECTION_LENGTH + x;
    }

    @Override
    public void reset() {
        for (BiomeCache cache : this.biomeCaches) {
            this.biomeCacheManager.release(cache);
        }
        Arrays.fill(this.biomeCaches, null);
        Arrays.fill(this.biomeArrays, null);
        Arrays.fill(this.blockLightArrays, null);
        Arrays.fill(this.skyLightArrays, null);
        this.biomeCacheManager = null;
        this.chunks = null;
        this.world = null;
        this.colorResolvers.clear();
        this.prevColorCache = null;
        this.prevColorResolver = null;
    }

    public int getBlockOffsetX() {
        return this.blockOffsetX;
    }

    public int getBlockOffsetY() {
        return this.blockOffsetY;
    }

    public int getBlockOffsetZ() {
        return this.blockOffsetZ;
    }
}

