/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.util.pool;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Supplier;
import me.jellysquid.mods.sodium.common.util.pool.ReusableObject;

public class ObjectPool<T extends ReusableObject> {
    private final ArrayBlockingQueue<T> pool;
    private final Supplier<T> factory;

    public ObjectPool(int size, Supplier<T> factory) {
        this.pool = new ArrayBlockingQueue(size);
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayBlockingQueue<T> arrayBlockingQueue = this.pool;
        synchronized (arrayBlockingQueue) {
            this.pool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T allocate() {
        ReusableObject obj;
        ArrayBlockingQueue<T> arrayBlockingQueue = this.pool;
        synchronized (arrayBlockingQueue) {
            obj = (ReusableObject)this.pool.poll();
        }
        if (obj == null) {
            obj = (ReusableObject)this.factory.get();
        }
        obj.acquireOwner();
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T obj) {
        if (((ReusableObject)obj).releaseReference()) {
            ((ReusableObject)obj).reset();
            ArrayBlockingQueue<T> arrayBlockingQueue = this.pool;
            synchronized (arrayBlockingQueue) {
                this.pool.offer(obj);
            }
        }
    }

    public void acquireReference(T obj) {
        ((ReusableObject)obj).acquireReference();
    }
}

