/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.pipeline;

import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.consumer.QuadVertexConsumer;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.sink.FallbackQuadSink;
import me.jellysquid.mods.sodium.client.render.pipeline.BlockRenderer;
import me.jellysquid.mods.sodium.client.render.pipeline.context.GlobalRenderContext;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import net.minecraft.class_778;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_778.class})
public class MixinBlockModelRenderer {
    private final XoRoShiRoRandom random = new XoRoShiRoRandom();

    @Inject(method={"render(Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/client/render/model/BakedModel;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;ZLjava/util/Random;JI)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void preRenderBlockInWorld(class_1920 world, class_1087 model, class_2680 state, class_2338 pos, class_4587 matrixStack, class_4588 consumer, boolean cull, Random rand, long seed, int int_1, CallbackInfoReturnable<Boolean> cir) {
        GlobalRenderContext renderer = GlobalRenderContext.getInstance(world);
        BlockRenderer blockRenderer = renderer.getBlockRenderer();
        boolean ret = blockRenderer.renderModel(world, state, pos, model, new FallbackQuadSink(consumer, matrixStack), cull, seed);
        cir.setReturnValue((Object)ret);
    }

    @Overwrite
    public void method_3367(class_4587.class_4665 entry, class_4588 vertexConsumer, class_2680 blockState, class_1087 bakedModel, float red, float green, float blue, int light, int overlay) {
        XoRoShiRoRandom random = this.random;
        QuadVertexConsumer quadConsumer = (QuadVertexConsumer)vertexConsumer;
        red = class_3532.method_15363((float)red, (float)0.0f, (float)1.0f);
        green = class_3532.method_15363((float)green, (float)0.0f, (float)1.0f);
        blue = class_3532.method_15363((float)blue, (float)0.0f, (float)1.0f);
        int defaultColor = ColorABGR.pack(red, green, blue, 1.0f);
        for (class_2350 direction : DirectionUtil.ALL_DIRECTIONS) {
            List quads = bakedModel.method_4707(blockState, direction, (Random)random.setSeedAndReturn(42L));
            if (quads.isEmpty()) continue;
            MixinBlockModelRenderer.renderQuad(entry, quadConsumer, defaultColor, quads, light, overlay);
        }
        List quads = bakedModel.method_4707(blockState, null, (Random)random.setSeedAndReturn(42L));
        if (!quads.isEmpty()) {
            MixinBlockModelRenderer.renderQuad(entry, quadConsumer, defaultColor, quads, light, overlay);
        }
    }

    private static void renderQuad(class_4587.class_4665 entry, QuadVertexConsumer vertices, int defaultColor, List<class_777> list, int light, int overlay) {
        if (list.isEmpty()) {
            return;
        }
        for (class_777 bakedQuad : list) {
            int color = bakedQuad.method_3360() ? defaultColor : -1;
            ModelQuadView quad = (ModelQuadView)bakedQuad;
            for (int i = 0; i < 4; ++i) {
                vertices.vertexQuad(entry, quad.getX(i), quad.getY(i), quad.getZ(i), color, quad.getTexU(i), quad.getTexV(i), light, overlay, ModelQuadUtil.getFacingNormal(bakedQuad.method_3358()));
            }
            SpriteUtil.markSpriteActive(quad.getSprite());
        }
    }
}

