/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.BOScreen;
import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Parsers;
import com.ldtteam.blockout.views.View;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.ToDoubleBiFunction;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class Window
extends View {
    protected static final int DEFAULT_WIDTH = 420;
    protected static final int DEFAULT_HEIGHT = 240;
    protected BOScreen screen;
    protected boolean windowPausesGame = true;
    protected boolean lightbox = true;
    protected WindowRenderType windowRenderType = WindowRenderType.OVERSIZED_VANILLA;

    public Window(ResourceLocation resource) {
        this();
        Loader.createFromXMLFile(resource, (View)this);
    }

    public Window() {
        this(420, 240);
    }

    public Window(int w, int h) {
        this.width = w;
        this.height = h;
        this.screen = new BOScreen(this);
        this.window = this;
    }

    public Window(String resource) {
        this();
        Loader.createFromXMLFile(resource, (View)this);
    }

    public void loadParams(@NotNull PaneParams params) {
        params.getResource("inherit", r -> Loader.createFromXMLFile(r, (View)this));
        params.applyShorthand("size", Parsers.INT, 2, a -> {
            this.width = (Integer)a.get(0);
            this.height = (Integer)a.get(1);
        });
        this.lightbox = params.getBoolean("lightbox", this.lightbox);
        this.windowPausesGame = params.getBoolean("pause", this.windowPausesGame);
        this.windowRenderType = params.getEnum("type", WindowRenderType.class, this.windowRenderType);
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        this.updateDebugging();
        super.drawSelf(ms, mx, my);
    }

    private boolean isKeyDown(int keyCode) {
        return InputMappings.func_216506_a((long)this.mc.field_195558_d.func_198092_i(), (int)keyCode);
    }

    private void updateDebugging() {
        debugging = this.isKeyDown(340) && this.isKeyDown(342) && (this.isKeyDown(341) || this.isKeyDown(343));
    }

    public boolean hasLightbox() {
        return this.lightbox;
    }

    public boolean doesWindowPauseGame() {
        return this.windowPausesGame;
    }

    public WindowRenderType getRenderType() {
        return this.windowRenderType;
    }

    public void open() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.mc.func_213167_f(() -> this.mc.func_147108_a((Screen)this.screen)));
    }

    public BOScreen getScreen() {
        return this.screen;
    }

    public boolean onMouseReleased(double mx, double my) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        if (Window.getFocus() != null && Window.getFocus().onKeyTyped(ch, key)) {
            return true;
        }
        return this.onUnhandledKeyTyped(ch, key);
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (key == 256) {
            this.close();
            return true;
        }
        return false;
    }

    public void close() {
        this.screen.func_231164_f_();
        this.mc.field_71439_g.func_71053_j();
    }

    public void onOpened() {
    }

    public void onClosed() {
    }

    public static enum WindowRenderType {
        VANILLA((mcWindow, window) -> Math.max(mcWindow.func_198100_s(), 1.0)),
        FULLSCREEN((mcWindow, window) -> {
            double widthScale = (double)mcWindow.func_198109_k() / (double)window.getWidth();
            double heightScale = (double)mcWindow.func_198091_l() / (double)window.getHeight();
            return Math.min(widthScale, heightScale);
        }),
        FULLSCREEN_VANILLA((mcWindow, window) -> {
            double widthScale = Math.max((double)mcWindow.func_198109_k(), 320.0) / (double)window.getWidth();
            double heightScale = Math.max((double)mcWindow.func_198091_l(), 240.0) / (double)window.getHeight();
            return Math.min(widthScale, heightScale);
        }),
        FIXED((mcWindow, window) -> 1.0),
        FIXED_VANILLA((mcWindow, window) -> Math.min(FULLSCREEN_VANILLA.calcRenderScale((MainWindow)mcWindow, (Window)((Object)window)), 1.0)),
        OVERSIZED((mcWindow, window) -> {
            double fs = FULLSCREEN.calcRenderScale((MainWindow)mcWindow, (Window)((Object)window));
            int userScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
            return fs < 1.0 ? fs : Math.min(Math.floor(fs), userScale == 0 ? Double.MAX_VALUE : (double)userScale);
        }),
        OVERSIZED_VANILLA((mcWindow, window) -> {
            double fs_vanilla = FULLSCREEN_VANILLA.calcRenderScale((MainWindow)mcWindow, (Window)((Object)window));
            int userScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
            return fs_vanilla < 1.0 ? fs_vanilla : Math.min(Math.floor(fs_vanilla), userScale == 0 ? Double.MAX_VALUE : (double)userScale);
        });

        private final ToDoubleBiFunction<MainWindow, Window> renderScaleCalculator;

        private WindowRenderType(ToDoubleBiFunction<MainWindow, Window> renderScaleCalculator) {
            this.renderScaleCalculator = renderScaleCalculator;
        }

        public double calcRenderScale(MainWindow mcWindow, Window window) {
            return this.renderScaleCalculator.applyAsDouble(mcWindow, window);
        }
    }
}

