/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection;

import com.ldtteam.shaded.mariuszgromada.math.mxparser.Argument;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.Expression;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mXparser;

public final class NumberTheory {
    public static final double min(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        return Math.min(a, b);
    }

    public static final double min(double ... numbers) {
        double min = Double.POSITIVE_INFINITY;
        for (double number : numbers) {
            if (Double.isNaN(number)) {
                return Double.NaN;
            }
            if (!(number < min)) continue;
            min = number;
        }
        return min;
    }

    public static final double max(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        return Math.max(a, b);
    }

    public static final double max(double ... numbers) {
        double max = Double.NEGATIVE_INFINITY;
        for (double number : numbers) {
            if (Double.isNaN(number)) {
                return Double.NaN;
            }
            if (!(number > max)) continue;
            max = number;
        }
        return max;
    }

    public static final double gcd(int a, int b) {
        a = Math.abs(a);
        b = Math.abs(b);
        if (a == 0) {
            return b;
        }
        while (b != 0) {
            if (a > b) {
                a -= b;
                continue;
            }
            b -= a;
        }
        return a;
    }

    public static final double gcd(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(a)) {
            return Double.NaN;
        }
        return NumberTheory.gcd((int)Math.round(a), (int)Math.round(b));
    }

    public static final double gcd(int ... numbers) {
        if (numbers.length == 1) {
            return numbers[0];
        }
        if (numbers.length == 2) {
            return NumberTheory.gcd(numbers[0], numbers[1]);
        }
        for (int i = 1; i < numbers.length; ++i) {
            numbers[i] = (int)NumberTheory.gcd(numbers[i - 1], numbers[i]);
        }
        return numbers[numbers.length - 1];
    }

    public static final double gcd(double ... numbers) {
        int[] intNumbers = new int[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            double n = numbers[i];
            if (Double.isNaN(n)) {
                return Double.NaN;
            }
            intNumbers[i] = (int)Math.round(n);
        }
        return NumberTheory.gcd(intNumbers);
    }

    public static final double lcm(int a, int b) {
        if (a == 0 || b == 0) {
            return 0.0;
        }
        return (double)Math.abs(a * b) / NumberTheory.gcd(a, b);
    }

    public static final double lcm(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(a)) {
            return Double.NaN;
        }
        return NumberTheory.lcm((int)Math.round(a), (int)Math.round(b));
    }

    public static final double lcm(int ... numbers) {
        if (numbers.length == 1) {
            return numbers[0];
        }
        if (numbers.length == 2) {
            return NumberTheory.lcm(numbers[0], numbers[1]);
        }
        for (int i = 1; i < numbers.length; ++i) {
            numbers[i] = (int)NumberTheory.lcm(numbers[i - 1], numbers[i]);
        }
        return numbers[numbers.length - 1];
    }

    public static final double lcm(double ... numbers) {
        int[] intNumbers = new int[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            double n = numbers[i];
            if (Double.isNaN(n)) {
                return Double.NaN;
            }
            intNumbers[i] = (int)Math.round(n);
            if (intNumbers[i] != 0) continue;
            return 0.0;
        }
        return NumberTheory.lcm(intNumbers);
    }

    public static final double sum(double ... numbers) {
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            return numbers[0];
        }
        double sum = 0.0;
        for (double xi : numbers) {
            if (Double.isNaN(xi)) {
                return Double.NaN;
            }
            sum += xi;
        }
        return sum;
    }

    public static final double prod(double ... numbers) {
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            return numbers[0];
        }
        double prod = 1.0;
        for (double xi : numbers) {
            if (Double.isNaN(xi)) {
                return Double.NaN;
            }
            prod *= xi;
        }
        return prod;
    }

    public static final boolean primeTest(long n) {
        if (n == 2L) {
            return true;
        }
        if (n % 2L == 0L) {
            return false;
        }
        if (n <= 1L) {
            return false;
        }
        long top = (long)Math.sqrt(n);
        long primesCacheOddEnd = 3L;
        if (mXparser.primesCache != null && mXparser.primesCache.cacheStatus) {
            long i;
            if (n <= (long)mXparser.primesCache.maxNumInCache) {
                return mXparser.primesCache.isPrime[(int)n];
            }
            long topCache = Math.min(top, (long)mXparser.primesCache.maxNumInCache);
            for (i = 3L; i <= topCache; i += 2L) {
                if (!mXparser.primesCache.isPrime[(int)i] || n % i != 0L) continue;
                return false;
            }
            primesCacheOddEnd = i;
        }
        for (long i = primesCacheOddEnd; i <= top; i += 2L) {
            if (n % i != 0L) continue;
            return false;
        }
        return true;
    }

    public static final double primeTest(double n) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        boolean isPrime = NumberTheory.primeTest((long)n);
        if (isPrime) {
            return 1.0;
        }
        return 0.0;
    }

    public static final long primeCount(long n) {
        if (n <= 1L) {
            return 0L;
        }
        if (n == 2L) {
            return 1L;
        }
        long numberOfPrimes = 1L;
        for (long i = 3L; i <= n; ++i) {
            if (!NumberTheory.primeTest(i)) continue;
            ++numberOfPrimes;
        }
        return numberOfPrimes;
    }

    public static final double primeCount(double n) {
        return NumberTheory.primeCount((long)n);
    }

    public static final double sigmaSummation(Expression f, Argument index, double from, double to, double delta) {
        double result = 0.0;
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        if (to >= from && delta > 0.0) {
            double i;
            for (i = from; i < to; i += delta) {
                result += mXparser.getFunctionValue(f, index, i);
            }
            if (delta - (i - to) > 0.5 * delta) {
                result += mXparser.getFunctionValue(f, index, to);
            }
        } else if (to <= from && delta < 0.0) {
            double i;
            for (i = from; i > to; i += delta) {
                result += mXparser.getFunctionValue(f, index, i);
            }
            if (delta - (to - i) > 0.5 * delta) {
                result += mXparser.getFunctionValue(f, index, to);
            }
        } else if (from == to) {
            result += mXparser.getFunctionValue(f, index, from);
        }
        return result;
    }

    public static final double piProduct(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        double result = 1.0;
        if (to >= from && delta > 0.0) {
            double i;
            for (i = from; i < to; i += delta) {
                result *= mXparser.getFunctionValue(f, index, i);
            }
            if (delta - (i - to) > 0.5 * delta) {
                result *= mXparser.getFunctionValue(f, index, to);
            }
        } else if (to <= from && delta < 0.0) {
            double i;
            for (i = from; i > to; i += delta) {
                result *= mXparser.getFunctionValue(f, index, i);
            }
            if (delta - (to - i) > 0.5 * delta) {
                result *= mXparser.getFunctionValue(f, index, to);
            }
        } else if (from == to) {
            result *= mXparser.getFunctionValue(f, index, from);
        }
        return result;
    }

    public static final double min(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        double min = Double.POSITIVE_INFINITY;
        if (to >= from && delta > 0.0) {
            double v;
            for (double i = from; i < to; i += delta) {
                v = mXparser.getFunctionValue(f, index, i);
                if (!(v < min)) continue;
                min = v;
            }
            v = mXparser.getFunctionValue(f, index, to);
            if (v < min) {
                min = v;
            }
        } else if (to <= from && delta < 0.0) {
            double v;
            for (double i = from; i > to; i += delta) {
                v = mXparser.getFunctionValue(f, index, i);
                if (!(v < min)) continue;
                min = v;
            }
            v = mXparser.getFunctionValue(f, index, to);
            if (v < min) {
                min = v;
            }
        } else if (from == to) {
            min = mXparser.getFunctionValue(f, index, from);
        }
        return min;
    }

    public static final double max(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        double max = Double.NEGATIVE_INFINITY;
        if (to >= from && delta > 0.0) {
            double v;
            for (double i = from; i < to; i += delta) {
                v = mXparser.getFunctionValue(f, index, i);
                if (!(v > max)) continue;
                max = v;
            }
            v = mXparser.getFunctionValue(f, index, to);
            if (v > max) {
                max = v;
            }
        } else if (to <= from && delta < 0.0) {
            double v;
            for (double i = from; i > to; i += delta) {
                v = mXparser.getFunctionValue(f, index, i);
                if (!(v > max)) continue;
                max = v;
            }
            v = mXparser.getFunctionValue(f, index, to);
            if (v > max) {
                max = v;
            }
        } else if (from == to) {
            max = mXparser.getFunctionValue(f, index, from);
        }
        return max;
    }
}

