/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.helpers;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.Shape;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public final class Settings {
    public static final Settings instance = new Settings();
    private BlockPos pos = null;
    private boolean isMirrored = false;
    @Nullable
    private Blueprint blueprint = null;
    private int rotation = 0;
    private String structureName = null;
    private Optional<BlockPos> anchorPos = Optional.empty();
    private String style = "";
    private int width = 1;
    private int height = 1;
    private int length = 1;
    private int frequency = 1;
    private String equation = "";
    private boolean hollow = false;
    private Shape shape = Shape.CUBE;
    private Tuple<BlockPos, BlockPos> box = null;
    private boolean staticSchematicMode = false;
    private String staticSchematicName = null;
    private Tuple<ItemStack, ItemStack> stack = new Tuple((Object)new ItemStack((IItemProvider)Blocks.field_150340_R), (Object)new ItemStack((IItemProvider)Blocks.field_150340_R));
    private boolean shouldRefresh = false;
    private boolean receivedInfo;
    private boolean isStructurizePass = false;

    private Settings() {
    }

    public void startStructurizePass() {
        this.isStructurizePass = true;
    }

    public void endStructurizePass() {
        this.isStructurizePass = false;
    }

    public boolean isStructurizePass() {
        return this.isStructurizePass;
    }

    public boolean shouldRefresh() {
        if (!this.isStructurizePass()) {
            return false;
        }
        boolean ret = this.shouldRefresh;
        this.shouldRefresh = false;
        return ret;
    }

    public void scheduleRefresh() {
        this.shouldRefresh = true;
    }

    public void setupStaticMode(String name) {
        this.staticSchematicMode = true;
        this.staticSchematicName = name;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    @Nullable
    public Tuple<BlockPos, BlockPos> getBox() {
        return this.box;
    }

    public void setBox(Tuple<BlockPos, BlockPos> box) {
        this.box = box;
    }

    public void setPosition(BlockPos position) {
        this.pos = position;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void moveTo(BlockPos pos) {
        if (this.blueprint == null) {
            return;
        }
        this.pos = this.pos.func_177971_a((Vector3i)pos);
    }

    @Nullable
    public Blueprint getActiveStructure() {
        return this.blueprint;
    }

    public void setActiveSchematic(Blueprint blueprint) {
        if (blueprint == null) {
            this.reset();
        } else {
            this.blueprint = blueprint;
            this.blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.rotation), this.isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, (World)Minecraft.func_71410_x().field_71441_e);
        }
    }

    public void reset() {
        this.blueprint = null;
        this.rotation = 0;
        this.isMirrored = false;
        this.staticSchematicMode = false;
        this.staticSchematicName = null;
        this.hollow = false;
        this.structureName = null;
        this.pos = null;
        this.box = null;
        this.equation = "";
    }

    public void softReset() {
        this.blueprint = null;
        this.staticSchematicMode = false;
        this.staticSchematicName = null;
        this.hollow = false;
        this.pos = null;
        this.box = null;
        this.equation = "";
    }

    public void setSchematicInfo(String structureName, int rotation) {
        this.structureName = structureName;
        this.rotation = rotation;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        int offset = rotation - this.rotation;
        this.rotation = rotation;
        if (this.blueprint != null) {
            this.blueprint.rotateWithMirror(offset == 1 || offset == -3 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90, Mirror.NONE, (World)Minecraft.func_71410_x().field_71441_e);
        }
        this.scheduleRefresh();
    }

    public void mirror() {
        if (this.blueprint == null) {
            return;
        }
        this.isMirrored = !this.isMirrored;
        this.blueprint.rotateWithMirror(Rotation.NONE, this.rotation % 2 == 0 ? Mirror.FRONT_BACK : Mirror.LEFT_RIGHT, (World)Minecraft.func_71410_x().field_71441_e);
        this.scheduleRefresh();
    }

    public Mirror getMirror() {
        if (this.isMirrored) {
            return Mirror.FRONT_BACK;
        }
        return Mirror.NONE;
    }

    public boolean isStaticSchematicMode() {
        return this.staticSchematicMode;
    }

    public String getStaticSchematicName() {
        return this.staticSchematicName;
    }

    public void setShape(String s) {
        this.shape = Shape.valueOf(s);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setBlock(ItemStack s, boolean mainBlock) {
        this.stack = mainBlock ? new Tuple((Object)s, this.stack.func_76340_b()) : new Tuple(this.stack.func_76341_a(), (Object)s);
    }

    public ItemStack getBlock(boolean main) {
        return main ? (ItemStack)this.stack.func_76341_a() : (ItemStack)this.stack.func_76340_b();
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public void setHollow(boolean hollow) {
        this.hollow = hollow;
    }

    public void fromBytes(PacketBuffer buf) {
        this.isMirrored = buf.readBoolean();
        this.staticSchematicMode = buf.readBoolean();
        this.hollow = buf.readBoolean();
        this.rotation = buf.readInt();
        this.width = buf.readInt();
        this.height = buf.readInt();
        this.length = buf.readInt();
        this.frequency = buf.readInt();
        this.shape = buf.readBoolean() ? Shape.values()[buf.readInt()] : Shape.CUBE;
        this.pos = buf.readBoolean() ? new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()) : null;
        this.box = buf.readBoolean() ? new Tuple((Object)new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()), (Object)new BlockPos(buf.readInt(), buf.readInt(), buf.readInt())) : null;
        this.structureName = buf.readBoolean() ? buf.func_150789_c(Short.MAX_VALUE) : null;
        this.staticSchematicName = buf.readBoolean() ? buf.func_150789_c(Short.MAX_VALUE) : null;
        this.stack = buf.readBoolean() ? new Tuple((Object)buf.func_150791_c(), (Object)buf.func_150791_c()) : new Tuple((Object)new ItemStack((IItemProvider)Blocks.field_150340_R), (Object)new ItemStack((IItemProvider)Blocks.field_150340_R));
        if (buf.readBoolean()) {
            this.equation = buf.func_150789_c(Short.MAX_VALUE);
        }
        if (buf.readBoolean()) {
            this.anchorPos = Optional.of(buf.func_179259_c());
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.isMirrored);
        buf.writeBoolean(this.staticSchematicMode);
        buf.writeBoolean(this.hollow);
        buf.writeInt(this.rotation);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
        buf.writeInt(this.length);
        buf.writeInt(this.frequency);
        buf.writeBoolean(this.shape != null);
        if (this.shape != null) {
            buf.writeInt(this.shape.ordinal());
        }
        buf.writeBoolean(this.pos != null);
        if (this.pos != null) {
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
        }
        buf.writeBoolean(this.box != null);
        if (this.box != null) {
            buf.writeInt(((BlockPos)this.box.func_76341_a()).func_177958_n());
            buf.writeInt(((BlockPos)this.box.func_76341_a()).func_177956_o());
            buf.writeInt(((BlockPos)this.box.func_76341_a()).func_177952_p());
            buf.writeInt(((BlockPos)this.box.func_76340_b()).func_177958_n());
            buf.writeInt(((BlockPos)this.box.func_76340_b()).func_177956_o());
            buf.writeInt(((BlockPos)this.box.func_76340_b()).func_177952_p());
        }
        buf.writeBoolean(this.structureName != null);
        if (this.structureName != null) {
            buf.func_180714_a(this.structureName);
        }
        buf.writeBoolean(this.staticSchematicName != null);
        if (this.staticSchematicName != null) {
            buf.func_180714_a(this.staticSchematicName);
        }
        buf.writeBoolean(this.stack != null);
        if (this.stack != null) {
            buf.func_150788_a((ItemStack)this.stack.func_76341_a());
            buf.func_150788_a((ItemStack)this.stack.func_76340_b());
        }
        buf.writeBoolean(!this.equation.isEmpty());
        if (!this.equation.isEmpty()) {
            buf.func_180714_a(this.equation);
        }
        buf.writeBoolean(this.anchorPos.isPresent());
        this.anchorPos.ifPresent(arg_0 -> ((PacketBuffer)buf).func_179255_a(arg_0));
    }

    public void setEquation(String localEquation) {
        this.equation = localEquation;
    }

    public String getEquation() {
        return this.equation;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Optional<BlockPos> getAnchorPos() {
        return this.anchorPos;
    }

    public void setAnchorPos(Optional<BlockPos> anchorPos) {
        this.anchorPos = anchorPos;
    }

    public boolean hasReceivedInfo() {
        return this.receivedInfo;
    }

    public void setReceivedInfo() {
        this.receivedInfo = true;
    }
}

