/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.util;

import com.ldtteam.structurize.api.util.ItemStackUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStorage {
    private final ItemStack stack;
    private final boolean shouldIgnoreDamageValue;
    private final boolean shouldIgnoreNBTValue;
    private int amount;

    public ItemStorage(@NotNull ItemStack stack, int amount, boolean ignoreDamageValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = ignoreDamageValue;
        this.amount = amount;
    }

    public ItemStorage(@NotNull ItemStack stack, boolean ignoreDamageValue, boolean shouldIgnoreNBTValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = shouldIgnoreNBTValue;
    }

    public ItemStorage(@NotNull ItemStack stack, boolean ignoreDamageValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = ignoreDamageValue;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public ItemStorage(@NotNull ItemStack stack) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = false;
        this.shouldIgnoreNBTValue = false;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public static ItemStorage getItemStackOfListMatchingPredicate(List<ItemStorage> list, Predicate<ItemStack> predicate) {
        for (ItemStorage stack : list) {
            if (!predicate.test(stack.getItemStack())) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean ignoreDamageValue() {
        return this.shouldIgnoreDamageValue;
    }

    public int hashCode() {
        return Objects.hash(this.stack.func_77973_b()) + (this.shouldIgnoreDamageValue ? 0 : this.stack.func_77952_i() * 31) + (this.shouldIgnoreNBTValue ? 0 : (this.stack.serializeNBT() == null ? 0 : this.stack.serializeNBT().hashCode()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStorage that = (ItemStorage)o;
        return !(!this.stack.func_77969_a(that.getItemStack()) || !this.shouldIgnoreDamageValue && that.getDamageValue() != this.getDamageValue() || !this.shouldIgnoreNBTValue && that.getItemStack().serializeNBT() != this.getItemStack().serializeNBT());
    }

    @NotNull
    public Item getItem() {
        return this.stack.func_77973_b();
    }

    public int getDamageValue() {
        return this.stack.func_77952_i();
    }
}

