/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.controls.ToggleButton;
import com.ldtteam.blockout.views.DropDownList;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowReplaceBlock;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.GenerateAndPasteMessage;
import com.ldtteam.structurize.network.messages.LSStructureDisplayerMessage;
import com.ldtteam.structurize.network.messages.UndoMessage;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowShapeTool
extends AbstractWindowSkeleton {
    private static final int POSSIBLE_ROTATIONS = 4;
    @NotNull
    private final List<String> sections = new ArrayList<String>();
    private DropDownList sectionsDropDownList;
    private TextField inputWidth;
    private TextField inputLength;
    private TextField inputHeight;
    private TextField inputFrequency;
    private TextField inputShape;
    private int shapeWidth = 1;
    private int shapeLength = 1;
    private int shapeHeight = 1;
    private int shapeFrequency = 1;
    private String shapeEquation = "";
    private int rotation = 0;
    @NotNull
    private BlockPos pos = new BlockPos(0, 0, 0);

    public WindowShapeTool(@Nullable BlockPos pos) {
        super("structurize:gui/windowshapetool.xml");
        if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.init(pos, false);
        }
    }

    public WindowShapeTool(@Nullable BlockPos pos, ItemStack stack, boolean mainBlock) {
        super("structurize:gui/windowshapetool.xml");
        if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            Settings.instance.setBlock(stack, mainBlock);
            this.init(pos, true);
        }
    }

    private void init(BlockPos pos, boolean shouldUpdate) {
        Blueprint structure = Settings.instance.getActiveStructure();
        if (structure != null) {
            this.rotation = Settings.instance.getRotation();
            this.shapeWidth = Settings.instance.getWidth();
            this.shapeLength = Settings.instance.getLength();
            this.shapeHeight = Settings.instance.getHeight();
            this.shapeFrequency = Settings.instance.getFrequency();
            this.shapeEquation = Settings.instance.getEquation();
        } else if (pos != null) {
            this.pos = pos;
            Settings.instance.setPosition(pos);
            Settings.instance.setRotation(0);
        }
        this.registerButton("confirm", this::paste);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("mirror", WindowShapeTool::mirror);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
        this.registerButton("plus", WindowShapeTool::moveUpClicked);
        this.registerButton("minus", WindowShapeTool::moveDownClicked);
        this.registerButton("rotateRight", this::rotateRightClicked);
        this.registerButton("rotateLeft", this::rotateLeftClicked);
        this.registerButton("pickMainBlock", this::pickMainBlock);
        this.registerButton("pickFillBlock", this::pickFillBlock);
        this.registerButton("replaceBlocks", this::replaceBlocksToggle);
        this.registerButton("hollowShape", this::hollowShapeToggle);
        this.registerButton("undo", this::undoClicked);
        this.inputWidth = this.findPaneOfTypeByID("width", TextField.class);
        this.inputLength = this.findPaneOfTypeByID("length", TextField.class);
        this.inputHeight = this.findPaneOfTypeByID("height", TextField.class);
        this.inputFrequency = this.findPaneOfTypeByID("frequency", TextField.class);
        this.inputShape = this.findPaneOfTypeByID("shape", TextField.class);
        this.inputWidth.setText(Integer.toString(Settings.instance.getWidth()));
        this.inputLength.setText(Integer.toString(Settings.instance.getLength()));
        this.inputHeight.setText(Integer.toString(Settings.instance.getHeight()));
        this.inputFrequency.setText(Integer.toString(Settings.instance.getFrequency()));
        this.inputShape.setText(Settings.instance.getEquation());
        this.sections.clear();
        this.sections.addAll(Arrays.stream(Shape.values()).map(Enum::name).collect(Collectors.toList()));
        this.sectionsDropDownList = this.findPaneOfTypeByID("style", DropDownList.class);
        this.sectionsDropDownList.setHandler(this::onDropDownListChanged);
        this.sectionsDropDownList.setDataProvider(new SectionDropDownList());
        this.sectionsDropDownList.setSelectedIndex(Settings.instance.getShape().ordinal());
        this.disableInputIfNecessary();
        if (structure == null || shouldUpdate) {
            WindowShapeTool.genShape();
        }
        this.findPaneOfTypeByID("hollowShape", ToggleButton.class).setActiveState(Settings.instance.isHollow() ? "hollow" : "solid");
    }

    private static void genShape() {
        Settings.instance.setActiveSchematic(Manager.getStructureFromFormula(Settings.instance.getWidth(), Settings.instance.getLength(), Settings.instance.getHeight(), Settings.instance.getFrequency(), Settings.instance.getEquation(), Settings.instance.getShape(), Settings.instance.getBlock(true), Settings.instance.getBlock(false), Settings.instance.isHollow()));
    }

    public static void commonStructureUpdate() {
        WindowShapeTool.genShape();
        WindowShapeTool.updateRotation(Settings.instance.getRotation());
    }

    private void disableInputIfNecessary() {
        Shape shape = Settings.instance.getShape();
        Text heightLabel = this.findPaneOfTypeByID("heightLabel", Text.class);
        Text widthLabel = this.findPaneOfTypeByID("widthLabel", Text.class);
        Text lengthLabel = this.findPaneOfTypeByID("lengthLabel", Text.class);
        Text frequencyLabel = this.findPaneOfTypeByID("frequencyLabel", Text.class);
        Text shapeLabel = this.findPaneOfTypeByID("shapeLabel", Text.class);
        this.inputHeight.show();
        this.inputWidth.show();
        this.inputLength.show();
        this.inputFrequency.show();
        this.inputShape.hide();
        heightLabel.show();
        widthLabel.show();
        lengthLabel.show();
        frequencyLabel.show();
        shapeLabel.hide();
        this.findPaneByID("hollowShape").show();
        this.findPaneByID("pickFillBlock").show();
        this.findPaneByID("resourceIconFill").show();
        if (shape == Shape.RANDOM) {
            this.inputShape.show();
            shapeLabel.show();
            this.inputFrequency.hide();
            frequencyLabel.hide();
            this.findPaneByID("hollowShape").hide();
            this.findPaneByID("pickFillBlock").hide();
            this.findPaneByID("resourceIconFill").hide();
        } else if (shape == Shape.SPHERE || shape == Shape.HALF_SPHERE || shape == Shape.BOWL || shape == Shape.PYRAMID || shape == Shape.UPSIDE_DOWN_PYRAMID || shape == Shape.DIAMOND) {
            this.inputWidth.hide();
            this.inputLength.hide();
            this.inputFrequency.hide();
            widthLabel.hide();
            lengthLabel.hide();
            frequencyLabel.hide();
        } else if (shape == Shape.CYLINDER) {
            this.inputLength.hide();
            lengthLabel.hide();
            this.inputFrequency.hide();
            frequencyLabel.hide();
        } else if (shape != Shape.WAVE && shape != Shape.WAVE_3D) {
            this.inputFrequency.hide();
            frequencyLabel.hide();
        }
    }

    private void pickMainBlock() {
        new WindowReplaceBlock(Settings.instance.getBlock(true), Settings.instance.getPosition(), true, (Window)this).open();
    }

    private void pickFillBlock() {
        new WindowReplaceBlock(Settings.instance.getBlock(false), Settings.instance.getPosition(), false, (Window)this).open();
    }

    private void replaceBlocksToggle() {
        Button replaceButton = this.findPaneOfTypeByID("replaceBlocks", Button.class);
        if (replaceButton.getTextAsString().equalsIgnoreCase(LanguageHandler.format("com.ldtteam.structurize.gui.shapetool.replace", new Object[0]))) {
            replaceButton.setText(LanguageHandler.format("com.ldtteam.structurize.gui.shapetool.ignore", new Object[0]));
        } else if (replaceButton.getTextAsString().equalsIgnoreCase(LanguageHandler.format("com.ldtteam.structurize.gui.shapetool.ignore", new Object[0]))) {
            replaceButton.setText(LanguageHandler.format("com.ldtteam.structurize.gui.shapetool.replace", new Object[0]));
        }
    }

    private void hollowShapeToggle() {
        ToggleButton hollowButton = this.findPaneOfTypeByID("hollowShape", ToggleButton.class);
        Settings.instance.setHollow(hollowButton.isActiveState("hollow"));
        WindowShapeTool.genShape();
    }

    private void undoClicked() {
        Network.getNetwork().sendToServer(new UndoMessage());
    }

    private void paste() {
        Network.getNetwork().sendToServer(new GenerateAndPasteMessage(Settings.instance.getPosition(), Settings.instance.getLength(), Settings.instance.getWidth(), Settings.instance.getHeight(), Settings.instance.getFrequency(), Settings.instance.getEquation(), Settings.instance.getShape(), Settings.instance.getBlock(true), Settings.instance.getBlock(false), Settings.instance.isHollow(), BlockUtils.getRotation(Settings.instance.getRotation()), Settings.instance.getMirror()));
        this.close();
    }

    private static void mirror() {
        Settings.instance.mirror();
    }

    @Override
    public void onOpened() {
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.close();
        }
        this.findPaneOfTypeByID("resourceIconMain", ItemIcon.class).setItem(Settings.instance.getBlock(true));
        this.findPaneOfTypeByID("resourceIconFill", ItemIcon.class).setItem(Settings.instance.getBlock(false));
        this.findPaneOfTypeByID("undo", Button.class).setVisible(true);
    }

    private void onDropDownListChanged(DropDownList list) {
        if (list.isEnabled() && list == this.sectionsDropDownList) {
            this.updateStyle(this.sections.get(this.sectionsDropDownList.getSelectedIndex()));
        }
    }

    private void updateStyle(String s) {
        if (Shape.valueOf(this.sections.get(this.sectionsDropDownList.getSelectedIndex())) != Settings.instance.getShape()) {
            Settings.instance.setShape(s);
            WindowShapeTool.genShape();
        }
        this.disableInputIfNecessary();
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        String widthText = this.inputWidth.getText();
        String lengthText = this.inputLength.getText();
        String heightText = this.inputHeight.getText();
        String frequencyText = this.inputFrequency.getText();
        String localEquation = this.inputShape.getText();
        if (!(widthText.isEmpty() || lengthText.isEmpty() || heightText.isEmpty())) {
            try {
                int localWidth = Integer.parseInt(widthText);
                int localHeight = Integer.parseInt(heightText);
                int localLength = Integer.parseInt(lengthText);
                int localFrequency = Integer.parseInt(frequencyText);
                if (this.shapeHeight != localHeight || this.shapeLength != localLength || this.shapeWidth != localWidth || this.shapeFrequency != localFrequency || !this.shapeEquation.equals(localEquation)) {
                    this.shapeWidth = localWidth;
                    this.shapeLength = localLength;
                    this.shapeHeight = localHeight;
                    this.shapeFrequency = localFrequency;
                    this.shapeEquation = localEquation;
                    Settings.instance.setWidth(localWidth);
                    Settings.instance.setLength(localLength);
                    Settings.instance.setHeight(localHeight);
                    Settings.instance.setFrequency(localFrequency);
                    Settings.instance.setEquation(localEquation);
                    WindowShapeTool.genShape();
                }
            }
            catch (NumberFormatException e) {
                this.inputWidth.setText(Integer.toString(Settings.instance.getWidth()));
                this.inputLength.setText(Integer.toString(Settings.instance.getLength()));
                this.inputHeight.setText(Integer.toString(Settings.instance.getHeight()));
            }
        }
        return result;
    }

    private static void moveUpClicked() {
        Settings.instance.moveTo(new BlockPos(0, 1, 0));
    }

    private static void moveDownClicked() {
        Settings.instance.moveTo(new BlockPos(0, -1, 0));
    }

    private void moveLeftClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176735_f()));
    }

    private void moveRightClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176746_e()));
    }

    private void moveForwardClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO()));
    }

    private void moveBackClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176734_d()));
    }

    private void rotateRightClicked() {
        this.rotation = (this.rotation + 1) % 4;
        WindowShapeTool.updateRotation(this.rotation);
    }

    private void rotateLeftClicked() {
        this.rotation = (this.rotation + 3) % 4;
        WindowShapeTool.updateRotation(this.rotation);
    }

    private void cancelClicked() {
        Settings.instance.reset();
        Network.getNetwork().sendToServer(new LSStructureDisplayerMessage(new PacketBuffer(Unpooled.buffer()), false));
        this.close();
    }

    private static void updateRotation(int rotation) {
        PlacementSettings settings = new PlacementSettings();
        switch (rotation) {
            case 1: {
                settings.setRotation(Rotation.CLOCKWISE_90);
                break;
            }
            case 2: {
                settings.setRotation(Rotation.CLOCKWISE_180);
                break;
            }
            case 3: {
                settings.setRotation(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            default: {
                settings.setRotation(Rotation.NONE);
            }
        }
        Settings.instance.setRotation(rotation);
        settings.setMirror(Settings.instance.getMirror());
    }

    @Override
    public void onClosed() {
        if (Settings.instance.getActiveStructure() != null) {
            ByteBuf buffer = Unpooled.buffer();
            PacketBuffer packetBuffer = new PacketBuffer(buffer);
            Settings.instance.toBytes(packetBuffer);
            Network.getNetwork().sendToServer(new LSStructureDisplayerMessage(packetBuffer, true));
        }
    }

    private class SectionDropDownList
    implements DropDownList.DataProvider {
        private SectionDropDownList() {
        }

        @Override
        public int getElementCount() {
            return WindowShapeTool.this.sections.size();
        }

        @Override
        public String getLabel(int index) {
            return (String)WindowShapeTool.this.sections.get(index);
        }
    }
}

