/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.Tuple;

public abstract class AbstractCommand {
    protected static Commands.EnvironmentType getEnvironmentType() {
        return Commands.EnvironmentType.ALL;
    }

    protected static LiteralArgumentBuilder<CommandSource> build() {
        throw new RuntimeException("Missing command builder!");
    }

    protected static LiteralArgumentBuilder<CommandSource> newLiteral(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    protected static <T> RequiredArgumentBuilder<CommandSource, T> newArgument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static void throwSyntaxException(String key) throws CommandSyntaxException {
        throw new CommandSyntaxException((CommandExceptionType)new StructurizeCommandExceptionType(), (Message)new LiteralMessage(LanguageHandler.translateKey(key)));
    }

    public static void throwSyntaxException(String key, Object ... format) throws CommandSyntaxException {
        throw new CommandSyntaxException((CommandExceptionType)new StructurizeCommandExceptionType(), (Message)new LiteralMessage(LanguageHandler.translateKeyWithFormat(key, format)));
    }

    protected static class CommandTree {
        private final List<CommandTree> childTrees = new ArrayList<CommandTree>();
        private final List<Tuple<Supplier<Commands.EnvironmentType>, Supplier<LiteralArgumentBuilder<CommandSource>>>> childNodes = new ArrayList<Tuple<Supplier<Commands.EnvironmentType>, Supplier<LiteralArgumentBuilder<CommandSource>>>>();
        private final Commands.EnvironmentType buildWhenOn;
        private final String commandName;

        protected static CommandTree newRootNode() {
            return new CommandTree(Commands.EnvironmentType.ALL, "structurize");
        }

        protected CommandTree(Commands.EnvironmentType environment, String commandName) {
            this.buildWhenOn = environment;
            this.commandName = commandName;
        }

        protected CommandTree addNode(CommandTree tree) {
            this.childTrees.add(tree);
            return this;
        }

        protected CommandTree addNode(Supplier<LiteralArgumentBuilder<CommandSource>> commandBuilder, Supplier<Commands.EnvironmentType> commandEnviroment) {
            this.childNodes.add((Tuple<Supplier<Commands.EnvironmentType>, Supplier<LiteralArgumentBuilder<CommandSource>>>)new Tuple(commandEnviroment, commandBuilder));
            return this;
        }

        protected Optional<LiteralArgumentBuilder<CommandSource>> build(Commands.EnvironmentType environment) {
            if (!this.checkEnvironment(environment, this.buildWhenOn)) {
                return Optional.empty();
            }
            LiteralArgumentBuilder<CommandSource> rootNode = AbstractCommand.newLiteral(this.commandName);
            for (Tuple<Supplier<Commands.EnvironmentType>, Supplier<LiteralArgumentBuilder<CommandSource>>> node : this.childNodes) {
                if (!this.checkEnvironment(environment, (Commands.EnvironmentType)((Supplier)node.func_76341_a()).get())) continue;
                rootNode.then((ArgumentBuilder)((Supplier)node.func_76340_b()).get());
            }
            for (CommandTree tree : this.childTrees) {
                Optional<LiteralArgumentBuilder<CommandSource>> builtTree = tree.build(environment);
                if (!builtTree.isPresent()) continue;
                rootNode.then((CommandNode)builtTree.get().build());
            }
            return this.childNodes.isEmpty() && this.childTrees.isEmpty() ? Optional.empty() : Optional.of(rootNode);
        }

        protected void register(CommandDispatcher<CommandSource> commandDispatcher, Commands.EnvironmentType serverEnvironmentType) {
            Optional<LiteralArgumentBuilder<CommandSource>> builtTree = this.build(serverEnvironmentType);
            if (builtTree.isPresent()) {
                commandDispatcher.register(builtTree.get());
            }
        }

        private boolean checkEnvironment(Commands.EnvironmentType server, Commands.EnvironmentType command) {
            return server == Commands.EnvironmentType.ALL || command == Commands.EnvironmentType.ALL || server == command;
        }
    }

    public static class StructurizeCommandExceptionType
    implements CommandExceptionType {
    }
}

