/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.defaults;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.loot_table.LootTableJson;
import com.ldtteam.datagenerators.loot_table.LootTableTypeEnum;
import com.ldtteam.datagenerators.loot_table.pool.PoolJson;
import com.ldtteam.datagenerators.loot_table.pool.conditions.survives_explosion.SurvivesExplosionConditionJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryTypeEnum;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.jetbrains.annotations.NotNull;

public class DefaultBlockLootTableProvider
implements IDataProvider {
    private final DataGenerator generator;

    public DefaultBlockLootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        this.saveBlocks(ModBlocks.getTimberFrames(), cache);
        this.saveBlocks(ModBlocks.getPaperwalls(), cache);
        this.saveBlocks(ModBlocks.getShingles(), cache);
        this.saveBlocks(ModBlocks.getShingleSlabs(), cache);
        this.saveBlocks(ModBlocks.getFloatingCarpets(), cache);
        this.saveBlock(ModBlocks.blockSubstitution, cache);
        this.saveBlock(ModBlocks.blockSolidSubstitution, cache);
        this.saveBlock(ModBlocks.blockFluidSubstitution, cache);
        this.saveBlock(ModBlocks.blockCactusPlank, cache);
        this.saveBlock((Block)ModBlocks.blockCactusTrapdoor, cache);
        this.saveBlock((Block)ModBlocks.blockCactusStair, cache);
        this.saveBlock((Block)ModBlocks.blockCactusSlab, cache);
        this.saveBlock((Block)ModBlocks.blockCactusFence, cache);
        this.saveBlock((Block)ModBlocks.blockCactusFenceGate, cache);
        this.saveBlock(ModBlocks.blockDecoBarrel_onside, cache);
        this.saveBlock(ModBlocks.blockDecoBarrel_standing, cache);
        this.saveBlock(ModBlocks.blockBrownBricks, cache);
        this.saveBlock(ModBlocks.blockBeigeBricks, cache);
        this.saveBlock(ModBlocks.blockCreamBricks, cache);
        this.saveBlock((Block)ModBlocks.blockBrownBrickSlab, cache);
        this.saveBlock((Block)ModBlocks.blockBeigeBrickSlab, cache);
        this.saveBlock((Block)ModBlocks.blockCreamBrickSlab, cache);
        this.saveBlock((Block)ModBlocks.blockBrownBrickWall, cache);
        this.saveBlock((Block)ModBlocks.blockBeigeBrickWall, cache);
        this.saveBlock((Block)ModBlocks.blockCreamBrickWall, cache);
        this.saveBlock((Block)ModBlocks.blockBrownBrickStairs, cache);
        this.saveBlock((Block)ModBlocks.blockBeigeBrickStairs, cache);
        this.saveBlock((Block)ModBlocks.blockCreamBrickStairs, cache);
        this.saveBlock(ModBlocks.multiBlock, cache);
        this.saveBlock(ModBlocks.blockBrownBricks, cache);
        this.saveBlock(ModBlocks.blockBeigeBricks, cache);
        this.saveBlock(ModBlocks.blockCreamBricks, cache);
        this.saveBlock((Block)ModBlocks.blockBrownBrickSlab, cache);
        this.saveBlock((Block)ModBlocks.blockBeigeBrickSlab, cache);
        this.saveBlock((Block)ModBlocks.blockCreamBrickSlab, cache);
        this.saveBlock((Block)ModBlocks.blockBrownBrickWall, cache);
        this.saveBlock((Block)ModBlocks.blockBeigeBrickWall, cache);
        this.saveBlock((Block)ModBlocks.blockCreamBrickWall, cache);
        this.saveBlock((Block)ModBlocks.blockBrownBrickStairs, cache);
        this.saveBlock((Block)ModBlocks.blockBeigeBrickStairs, cache);
        this.saveBlock((Block)ModBlocks.blockCreamBrickStairs, cache);
    }

    private <T extends Block> void saveBlocks(List<T> blocks, DirectoryCache cache) throws IOException {
        for (Block block : blocks) {
            this.saveBlock(block, cache);
        }
    }

    private void saveBlock(Block block, DirectoryCache cache) throws IOException {
        if (block.getRegistryName() != null) {
            EntryJson entryJson = new EntryJson();
            entryJson.setType(EntryTypeEnum.ITEM);
            entryJson.setName(block.getRegistryName().toString());
            PoolJson poolJson = new PoolJson();
            poolJson.setEntries(Collections.singletonList(entryJson));
            poolJson.setRolls(1);
            poolJson.setConditions(Collections.singletonList(new SurvivesExplosionConditionJson()));
            LootTableJson lootTableJson = new LootTableJson();
            lootTableJson.setType(LootTableTypeEnum.BLOCK);
            lootTableJson.setPools(Collections.singletonList(poolJson));
            Path savePath = this.generator.func_200391_b().resolve("data/structurize/loot_tables/blocks").resolve(block.getRegistryName().func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)lootTableJson), (Path)savePath);
        }
    }

    @NotNull
    public String func_200397_b() {
        return "Default Block Loot Tables Provider";
    }
}

