/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.shingle_slabs;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockShingleSlab;
import com.ldtteam.structurize.blocks.types.ShingleSlabShapeType;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.Direction;
import org.jetbrains.annotations.NotNull;

public class ShingleSlabsBlockStateProvider
implements IDataProvider {
    private final DataGenerator generator;

    public ShingleSlabsBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path inputPath = this.generator.func_200389_a().stream().findFirst().orElse(null);
        if (inputPath == null) {
            return;
        }
        for (BlockShingleSlab shingleSlab : ModBlocks.getShingleSlabs()) {
            this.createBlockstateFile(cache, shingleSlab);
        }
    }

    private void createBlockstateFile(DirectoryCache cache, BlockShingleSlab shingleSlab) throws IOException {
        if (shingleSlab.getRegistryName() == null) {
            return;
        }
        HashMap<String, BlockstateVariantJson> variants = new HashMap<String, BlockstateVariantJson>();
        for (ShingleSlabShapeType shingleSlabShape : BlockShingleSlab.SHAPE.func_177700_c()) {
            for (Direction shingleSlabFacing : BlockShingleSlab.field_185512_D.func_177700_c()) {
                String variantKey = "shape=" + shingleSlabShape.getName() + ",facing=" + shingleSlabFacing.func_176610_l();
                int y = this.getYFromFacing(shingleSlabFacing);
                String modelLocation = "structurize:block/shingle_slab/" + shingleSlab.getRegistryName().func_110623_a() + "_" + shingleSlabShape.getName();
                BlockstateModelJson model = new BlockstateModelJson(modelLocation, 0, y);
                BlockstateVariantJson variant = new BlockstateVariantJson(model);
                variants.put(variantKey, variant);
            }
        }
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.func_200391_b().resolve("assets/structurize/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(shingleSlab.getRegistryName().func_110623_a() + ".json");
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    @NotNull
    public String func_200397_b() {
        return "Shingle Slab BlockStates Provider";
    }

    private int getYFromFacing(Direction facing) {
        switch (facing) {
            default: {
                return 270;
            }
            case EAST: {
                return 0;
            }
            case SOUTH: {
                return 90;
            }
            case WEST: 
        }
        return 180;
    }
}

