/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.shingles;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockShingle;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.block.StairsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import org.jetbrains.annotations.NotNull;

public class ShinglesBlockStateProvider
implements IDataProvider {
    private final DataGenerator generator;

    public ShinglesBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path inputPath = this.generator.func_200389_a().stream().findFirst().orElse(null);
        if (inputPath == null) {
            return;
        }
        for (BlockShingle shingle : ModBlocks.getShingles()) {
            this.createBlockstateFile(cache, shingle);
        }
    }

    private void createBlockstateFile(DirectoryCache cache, BlockShingle shingle) throws IOException {
        if (shingle.getRegistryName() == null) {
            return;
        }
        HashMap<String, BlockstateVariantJson> variants = new HashMap<String, BlockstateVariantJson>();
        for (Direction facingValue : StairsBlock.field_176309_a.func_177700_c()) {
            for (StairsShape shapeValue : StairsBlock.field_176310_M.func_177700_c()) {
                for (Half halfValue : StairsBlock.field_176308_b.func_177700_c()) {
                    String variantKey = "facing=" + facingValue + ",shape=" + shapeValue + ",half=" + halfValue;
                    int y = this.getYFromFacing(facingValue);
                    y += this.getYFromShape(shapeValue);
                    int x = halfValue == Half.TOP ? 180 : 0;
                    String modelLocation = "structurize:block/shingle/" + BlockShingle.getTypeFromShape(shapeValue) + "/" + shingle.getWoodType().getName() + "/" + shingle.getFaceType().getName() + "_shingle";
                    BlockstateModelJson model = new BlockstateModelJson(modelLocation, x, y += this.getYFromHalf(halfValue, shapeValue));
                    BlockstateVariantJson variant = new BlockstateVariantJson(model);
                    variants.put(variantKey, variant);
                }
            }
        }
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.func_200391_b().resolve("assets/structurize/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(shingle.getRegistryName().func_110623_a() + ".json");
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    @NotNull
    public String func_200397_b() {
        return "Shingles BlockStates Provider";
    }

    private int getYFromHalf(Half half, StairsShape shape) {
        if (half == Half.TOP) {
            if (shape == StairsShape.STRAIGHT) {
                return 180;
            }
            return 90;
        }
        return 0;
    }

    private int getYFromShape(StairsShape shape) {
        switch (shape) {
            default: {
                return 0;
            }
            case OUTER_RIGHT: 
            case INNER_RIGHT: 
        }
        return 90;
    }

    private int getYFromFacing(Direction facing) {
        switch (facing) {
            default: {
                return 0;
            }
            case WEST: {
                return 90;
            }
            case NORTH: {
                return 180;
            }
            case EAST: 
        }
        return 270;
    }
}

