/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.timber_frames;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.models.block.BlockModelJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockTimberFrame;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.jetbrains.annotations.NotNull;

public class TimberFramesBlockModelProvider
implements IDataProvider {
    private final DataGenerator generator;

    public TimberFramesBlockModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path inputPath = this.generator.func_200389_a().stream().findFirst().orElse(null);
        if (inputPath == null) {
            return;
        }
        for (BlockTimberFrame timberFrame : ModBlocks.getTimberFrames()) {
            File modelFile = inputPath.resolve("assets/structurize/models/block/timber_frames/" + timberFrame.getTimberFrameType().getName() + ".json").toFile();
            FileReader reader = new FileReader(modelFile);
            BlockModelJson modelJson = new BlockModelJson();
            modelJson.deserialize(new JsonParser().parse((Reader)reader));
            HashMap<String, String> textures = modelJson.getTextures();
            if (textures == null) {
                textures = new HashMap<String, String>();
            }
            textures.put("frame", timberFrame.getFrameType().getTextureLocation());
            textures.put("centre", timberFrame.getCentreType().getTextureLocation());
            textures.put("particle", timberFrame.getFrameType().getTextureLocation());
            modelJson.setTextures(textures);
            String name = timberFrame.getTimberFrameType().getName() + "_" + timberFrame.getFrameType().getName() + "_" + timberFrame.getCentreType().getName() + "_timber_frame.json";
            Path saveFile = this.generator.func_200391_b().resolve("assets/structurize/models/block/timber_frames/").resolve(name);
            IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)modelJson), (Path)saveFile);
        }
    }

    @NotNull
    public String func_200397_b() {
        return "Timber Frames Block Model Provider";
    }
}

