/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.timber_frames;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.recipes.RecipeIngredientJson;
import com.ldtteam.datagenerators.recipes.RecipeIngredientKeyJson;
import com.ldtteam.datagenerators.recipes.RecipeResultJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedPatternJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedRecipeJson;
import com.ldtteam.datagenerators.recipes.shapeless.ShapelessRecipeJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockTimberFrame;
import com.ldtteam.structurize.blocks.types.TimberFrameType;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import com.ldtteam.structurize.items.ModItems;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.jetbrains.annotations.NotNull;

public class TimberFramesRecipeProvider
implements IDataProvider {
    private final DataGenerator generator;

    public TimberFramesRecipeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path inputPath = this.generator.func_200389_a().stream().findFirst().orElse(null);
        if (inputPath == null) {
            return;
        }
        for (int i = 0; i < ModBlocks.getTimberFrames().size(); ++i) {
            BlockTimberFrame timberFrame = ModBlocks.getTimberFrames().get(i);
            if (timberFrame.getTimberFrameType().equals((Object)TimberFrameType.PLAIN)) {
                this.createPlainTimberFrameRecipe(cache, timberFrame);
            }
            this.createDyableShingleRecipe(cache, timberFrame);
        }
    }

    @NotNull
    public String func_200397_b() {
        return "Timber Frame Recipes";
    }

    private void createDyableShingleRecipe(DirectoryCache cache, BlockTimberFrame timberFrame) throws IOException {
        if (timberFrame.getRegistryName() == null) {
            return;
        }
        ShapelessRecipeJson recipeJson = new ShapelessRecipeJson();
        String groupName = timberFrame.getFrameType().getName() + "_" + timberFrame.getCentreType().getName() + "_timber_frame";
        recipeJson.setGroup(groupName);
        recipeJson.setResult(new RecipeResultJson(1, timberFrame.getRegistryName().toString()));
        ArrayList<RecipeIngredientKeyJson> ingredients = new ArrayList<RecipeIngredientKeyJson>();
        TimberFrameType previous = timberFrame.getTimberFrameType().getPrevious();
        String recipeIngredient = "structurize:" + BlockTimberFrame.getName(previous, timberFrame.getFrameType(), timberFrame.getCentreType());
        ingredients.add(new RecipeIngredientKeyJson(new RecipeIngredientJson(recipeIngredient, false)));
        recipeJson.setIngredients(ingredients);
        String name = timberFrame.getRegistryName().func_110623_a();
        if (timberFrame.getTimberFrameType().equals((Object)TimberFrameType.PLAIN)) {
            name = timberFrame.getRegistryName().func_110623_a() + "_cycle";
        }
        Path recipePath = this.generator.func_200391_b().resolve("data/structurize//recipes/").resolve(name + ".json");
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)recipeJson), (Path)recipePath);
    }

    private void createPlainTimberFrameRecipe(DirectoryCache cache, BlockTimberFrame timberFrame) throws IOException {
        if (timberFrame.getRegistryName() == null || ModItems.buildTool.getRegistryName() == null) {
            return;
        }
        String name = timberFrame.getRegistryName().func_110623_a();
        String groupName = timberFrame.getFrameType().getName() + "_" + timberFrame.getCentreType().getName() + "_timber_frame";
        ShapedRecipeJson recipeJson = new ShapedRecipeJson();
        recipeJson.setGroup(groupName);
        recipeJson.setPattern(new ShapedPatternJson(" F ", " C ", " S "));
        recipeJson.setResult(new RecipeResultJson(4, timberFrame.getRegistryName().toString()));
        HashMap<String, RecipeIngredientKeyJson> ingredients = new HashMap<String, RecipeIngredientKeyJson>();
        RecipeIngredientJson ingredientF = new RecipeIngredientJson(timberFrame.getFrameType().getRecipeIngredient(), false);
        ingredients.put("F", new RecipeIngredientKeyJson(ingredientF));
        RecipeIngredientJson ingredientC = new RecipeIngredientJson(timberFrame.getCentreType().getRecipeIngredient(), false);
        ingredients.put("C", new RecipeIngredientKeyJson(ingredientC));
        RecipeIngredientJson ingredientS = new RecipeIngredientJson(ModItems.buildTool.getRegistryName().toString(), false);
        ingredients.put("S", new RecipeIngredientKeyJson(ingredientS));
        recipeJson.setKey(ingredients);
        Path recipePath = this.generator.func_200391_b().resolve("data/structurize//recipes/").resolve(name + ".json");
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)recipeJson), (Path)recipePath);
    }
}

