/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.util.LanguageHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCaliper
extends AbstractItemWithPosSelector {
    private static final String ITEM_CALIPER_MESSAGE_SAME = "item.caliper.message.same";
    private static final String ITEM_CALIPER_MESSAGE_BASE = "item.caliper.message.base";
    private static final String ITEM_CALIPER_MESSAGE_BY = "item.caliper.message.by";
    private static final String ITEM_CALIPER_MESSAGE_XD = "item.caliper.message.%sd";

    public ItemCaliper(Item.Properties properties) {
        super(properties.func_200917_a(1));
        this.setRegistryName("caliper");
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return ModItems.caliper;
    }

    @Override
    public ActionResultType onAirRightClick(BlockPos start, BlockPos end, World worldIn, PlayerEntity playerIn, ItemStack itemStack) {
        if (!worldIn.field_72995_K) {
            return ActionResultType.FAIL;
        }
        if (start.equals((Object)end)) {
            LanguageHandler.sendMessageToPlayer(playerIn, ITEM_CALIPER_MESSAGE_SAME, new Object[0]);
            return ActionResultType.FAIL;
        }
        this.handlePlayerMessage(start, end, playerIn);
        return ActionResultType.SUCCESS;
    }

    private void handlePlayerMessage(BlockPos start, BlockPos end, PlayerEntity playerIn) {
        int disX = Math.abs(end.func_177958_n() - start.func_177958_n());
        int disY = Math.abs(end.func_177956_o() - start.func_177956_o());
        int disZ = Math.abs(end.func_177952_p() - start.func_177952_p());
        int flag = 3;
        if (start.func_177958_n() == end.func_177958_n()) {
            --flag;
        }
        if (start.func_177956_o() == end.func_177956_o()) {
            --flag;
        }
        if (start.func_177952_p() == end.func_177952_p()) {
            --flag;
        }
        String by = " " + LanguageHandler.translateKey(ITEM_CALIPER_MESSAGE_BY) + " ";
        StringBuilder msg = new StringBuilder();
        if (disX != 0) {
            msg.append(++disX);
            msg.append(by);
        }
        if (disY != 0) {
            msg.append(++disY);
            msg.append(by);
        }
        if (disZ != 0) {
            msg.append(++disZ);
            msg.append(by);
        }
        msg.delete(msg.length() - by.length(), msg.length());
        msg = new StringBuilder(LanguageHandler.translateKeyWithFormat(ITEM_CALIPER_MESSAGE_BASE, msg.toString()));
        msg.append(" ");
        msg.append(LanguageHandler.translateKeyWithFormat(String.format(ITEM_CALIPER_MESSAGE_XD, flag), new Object[0]));
        LanguageHandler.sendMessageToPlayer(playerIn, msg.toString(), new Object[0]);
    }
}

