/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.client.gui.WindowShapeTool;
import com.ldtteam.structurize.management.linksession.ChannelsEnum;
import com.ldtteam.structurize.management.linksession.LinkSessionManager;
import com.ldtteam.structurize.network.messages.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LSStructureDisplayerMessage
implements IMessage {
    private final PacketBuffer settings;
    private final boolean show;

    public LSStructureDisplayerMessage(PacketBuffer buf) {
        this.show = buf.readBoolean();
        if (this.show) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            this.settings = new PacketBuffer(Unpooled.wrappedBuffer((byte[])bytes));
        } else {
            this.settings = null;
        }
    }

    public LSStructureDisplayerMessage(@NotNull PacketBuffer settings, @NotNull boolean show) {
        this.settings = settings;
        this.show = show;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.show);
        if (this.show) {
            buf.writeBytes((ByteBuf)this.settings);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return null;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (isLogicalServer) {
            ServerPlayerEntity player = ctxIn.getSender();
            if (LinkSessionManager.INSTANCE.getMuteState(player.func_110124_au(), ChannelsEnum.STRUCTURE_DISPLAYER)) {
                return;
            }
            Set<UUID> targets = LinkSessionManager.INSTANCE.execute(player.func_110124_au(), ChannelsEnum.STRUCTURE_DISPLAYER);
            targets.remove(player.func_110124_au());
            for (UUID target : targets) {
                ServerPlayerEntity playerEntity = player.func_184102_h().func_184103_al().func_177451_a(target);
                if (playerEntity == null) continue;
                Network.getNetwork().sendToPlayer(new LSStructureDisplayerMessage(this.settings, this.show), playerEntity);
            }
        } else if (this.show) {
            Settings.instance.fromBytes(this.settings);
            if (Settings.instance.getStructureName() == null && Settings.instance.getStaticSchematicName() == null) {
                WindowShapeTool.commonStructureUpdate();
            } else {
                WindowBuildTool.commonStructureUpdate();
            }
        } else {
            Settings.instance.reset();
        }
    }
}

