/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.handlers.placement;

import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.InventoryUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IPlacementHandler {
    public boolean canHandle(@NotNull World var1, @NotNull BlockPos var2, @NotNull BlockState var3);

    default public ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
        return ActionProcessingResult.PASS;
    }

    default public ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
        return this.handle(world, pos, blockState, tileEntityData, complete, centerPos);
    }

    default public void handleRemoval(@NotNull IStructureHandler handler, @NotNull World world, @NotNull BlockPos pos, @NotNull CompoundNBT tileEntityData) {
        this.handleRemoval(handler, world, pos);
    }

    default public void handleRemoval(@NotNull IStructureHandler handler, @NotNull World world, @NotNull BlockPos pos) {
        if (!handler.isCreative()) {
            List<ItemStack> items = BlockUtils.getBlockDrops(world, pos, 0, handler.getHeldItem());
            for (ItemStack item : items) {
                InventoryUtils.transferIntoNextBestSlot(item, handler.getInventory());
            }
        } else if (world.func_175625_s(pos) != null) {
            world.func_175713_t(pos);
        }
        world.func_217377_a(pos, false);
    }

    public List<ItemStack> getRequiredItems(@NotNull World var1, @NotNull BlockPos var2, @NotNull BlockState var3, @Nullable CompoundNBT var4, boolean var5);

    public static enum ActionProcessingResult {
        PASS,
        DENY,
        SUCCESS;

    }
}

