/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.handlers.placement;

import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.schematic.BlockFluidSubstitution;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.DragonEggBlock;
import net.minecraft.block.EndPortalBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlacementHandlers {
    public static final List<IPlacementHandler> handlers = new ArrayList<IPlacementHandler>();

    public static void add(IPlacementHandler handler, Class<?> override) {
        for (int i = 0; i < handlers.size(); ++i) {
            if (!override.isInstance(handlers.get(i))) continue;
            handlers.set(i, handler);
            return;
        }
        PlacementHandlers.add(handler);
    }

    public static void add(IPlacementHandler handler) {
        handlers.add(1, handler);
    }

    private PlacementHandlers() {
    }

    public static void handleTileEntityPlacement(CompoundNBT tileEntityData, World world, @NotNull BlockPos pos, PlacementSettings settings) {
        TileEntity newTile;
        if (tileEntityData != null && (newTile = TileEntity.func_235657_b_((BlockState)world.func_180495_p(pos), (CompoundNBT)tileEntityData)) != null) {
            world.func_175690_a(pos, newTile);
            newTile.func_189667_a(settings.rotation);
            newTile.func_189668_a(settings.mirror);
        }
    }

    public static List<ItemStack> getRequiredItemsForState(World world, BlockPos pos, BlockState state, CompoundNBT data, boolean complete) {
        for (IPlacementHandler placementHandler : handlers) {
            if (!placementHandler.canHandle(world, pos, state)) continue;
            return placementHandler.getRequiredItems(world, pos, state, data, complete);
        }
        return Collections.emptyList();
    }

    public static void handleTileEntityPlacement(CompoundNBT tileEntityData, World world, @NotNull BlockPos pos) {
        PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, new PlacementSettings());
    }

    public static List<ItemStack> getItemsFromTileEntity(CompoundNBT tileEntityData, World world, BlockPos pos) {
        if (tileEntityData != null) {
            return ItemStackUtils.getItemStacksOfTileEntity(tileEntityData, world, pos);
        }
        return Collections.emptyList();
    }

    static {
        handlers.add(new AirPlacementHandler());
        handlers.add(new FluidSubstitutionPlacementHandler());
        handlers.add(new WaterPlacementHandler());
        handlers.add(new FirePlacementHandler());
        handlers.add(new GrassPlacementHandler());
        handlers.add(new DoorPlacementHandler());
        handlers.add(new BedPlacementHandler());
        handlers.add(new DoublePlantPlacementHandler());
        handlers.add(new SpecialBlockPlacementAttemptHandler());
        handlers.add(new FlowerPotPlacementHandler());
        handlers.add(new BlockGrassPathPlacementHandler());
        handlers.add(new StairBlockPlacementHandler());
        handlers.add(new ChestPlacementHandler());
        handlers.add(new FallingBlockPlacementHandler());
        handlers.add(new BannerPlacementHandler());
        handlers.add(new GeneralBlockPlacementHandler());
    }

    public static class BannerPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof BannerBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (world.func_180495_p(pos).equals(blockState)) {
                if (tileEntityData != null) {
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
                }
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, world, pos));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class ChestPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof ChestBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.addAll(PlacementHandlers.getItemsFromTileEntity(tileEntityData, world, pos));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class GeneralBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return true;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
            if (world.func_180495_p(pos).equals(blockState)) {
                if (tileEntityData != null) {
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
                }
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, world, pos));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class StairBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof StairsBlock && world.func_180495_p(pos).func_177230_c() instanceof StairsBlock && world.func_180495_p(pos).func_177229_b((Property)StairsBlock.field_176309_a) == blockState.func_177229_b((Property)StairsBlock.field_176309_a) && blockState.func_177230_c() == world.func_180495_p(pos).func_177230_c();
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class BlockGrassPathPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof GrassPathBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(new ItemStack((IItemProvider)Blocks.field_150346_d, 1));
            return itemList;
        }
    }

    public static class AirPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof AirBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.func_175623_d(pos)) {
                List entityList = world.func_175647_a(Entity.class, new AxisAlignedBB(pos), entity -> !(entity instanceof LivingEntity) && !(entity instanceof ItemEntity));
                if (!entityList.isEmpty()) {
                    for (Entity entity2 : entityList) {
                        entity2.func_70106_y();
                    }
                }
                world.func_217377_a(pos, false);
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class FlowerPotPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof FlowerPotBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (world.func_180495_p(pos).func_177230_c() == blockState.func_177230_c()) {
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.addAll(PlacementHandlers.getItemsFromTileEntity(tileEntityData, world, pos));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class SpecialBlockPlacementAttemptHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof EndPortalBlock || blockState.func_177230_c() instanceof SpawnerBlock || blockState.func_177230_c() instanceof DragonEggBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class DoublePlantPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof DoublePlantBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (((DoubleBlockHalf)blockState.func_177229_b((Property)DoublePlantBlock.field_176492_b)).equals((Object)DoubleBlockHalf.LOWER)) {
                world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER), 3);
                world.func_180501_a(pos.func_177984_a(), (BlockState)blockState.func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER), 3);
                return IPlacementHandler.ActionProcessingResult.SUCCESS;
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            return itemList;
        }
    }

    public static class BedPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof BedBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (blockState.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.HEAD) {
                Direction facing = (Direction)blockState.func_177229_b((Property)BedBlock.field_185512_D);
                world.func_180501_a(pos.func_177972_a(facing.func_176734_d()), (BlockState)blockState.func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.FOOT), 3);
                world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD), 3);
                if (tileEntityData != null) {
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos.func_177972_a(facing.func_176734_d()));
                }
                return IPlacementHandler.ActionProcessingResult.SUCCESS;
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            if (blockState.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.HEAD) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                list.add(new ItemStack((IItemProvider)blockState.func_177230_c(), 1));
                return list;
            }
            return Collections.emptyList();
        }
    }

    public static class DoorPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof DoorBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (((DoubleBlockHalf)blockState.func_177229_b((Property)DoorBlock.field_176523_O)).equals((Object)DoubleBlockHalf.LOWER)) {
                world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER), 3);
                world.func_180501_a(pos.func_177984_a(), (BlockState)blockState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), 3);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            if (((DoubleBlockHalf)blockState.func_177229_b((Property)DoorBlock.field_176523_O)).equals((Object)DoubleBlockHalf.LOWER)) {
                itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            }
            return itemList;
        }
    }

    public static class GrassPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() == Blocks.field_196658_i;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.func_180501_a(pos, Blocks.field_196658_i.func_176223_P(), 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(new ItemStack((IItemProvider)Blocks.field_150346_d));
            return itemList;
        }
    }

    public static class FallingBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof FallingBlock;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, world, pos));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            if (!world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
                itemList.addAll(PlacementHandlers.getRequiredItemsForState(world, pos, BlockUtils.getSubstitutionBlockAtWorld(world, pos), tileEntityData, complete));
            }
            return itemList;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (world.func_180495_p(pos).equals(blockState)) {
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
                world.func_180501_a(pos.func_177977_b(), BlockUtils.getSubstitutionBlockAtWorld(world, pos), 3);
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }
    }

    public static class FirePlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof FireBlock;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(new ItemStack((IItemProvider)Items.field_151033_d, 1));
            return itemList;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            world.func_180501_a(pos, blockState, 3);
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
    }

    public static class FluidSubstitutionPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() instanceof BlockFluidSubstitution;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (BlockUtils.getFluidForDimension(world).func_177230_c() == Blocks.field_150353_l) {
                items.add(new ItemStack((IItemProvider)Items.field_151129_at));
            }
            return items;
        }

        @Override
        public void handleRemoval(@NotNull IStructureHandler handler, @NotNull World world, @NotNull BlockPos pos, @NotNull CompoundNBT tileEntityData) {
            BlockState state = world.func_180495_p(pos);
            if (!state.func_235901_b_((Property)BlockStateProperties.field_208198_y) || ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() || BlockUtils.getFluidForDimension(world).func_177230_c() != Blocks.field_150355_j) {
                this.handleRemoval(handler, world, pos);
            }
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            if (complete) {
                world.func_180501_a(pos, ModBlocks.blockFluidSubstitution.func_176223_P(), 3);
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (world.func_180495_p(pos).func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                world.func_180501_a(pos, BlockUtils.getFluidForDimension(world), 3);
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
    }

    public static class WaterPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
            return blockState.func_177230_c() == Blocks.field_150355_j;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
            return Collections.emptyList();
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
            world.func_180501_a(pos, blockState, 3);
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
    }
}

