/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.PositionStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeEntity;

public class ChangeStorage {
    private final Map<BlockPos, PositionStorage> blocks = new HashMap<BlockPos, PositionStorage>();
    private final List<CompoundNBT> entities = new ArrayList<CompoundNBT>();
    private final List<Entity> entitiesToKill = new ArrayList<Entity>();
    private final PlayerEntity player;

    public ChangeStorage(PlayerEntity player) {
        this.player = player;
    }

    public ChangeStorage(World world, BlockPos from, BlockPos to, PlayerEntity player) {
        this.player = player;
        for (int x = Math.min(from.func_177958_n(), to.func_177958_n()); x <= Math.max(from.func_177958_n(), to.func_177958_n()); ++x) {
            for (int y = Math.min(from.func_177956_o(), to.func_177956_o()); y <= Math.max(from.func_177956_o(), to.func_177956_o()); ++y) {
                for (int z = Math.min(from.func_177952_p(), to.func_177952_p()); z <= Math.max(from.func_177952_p(), to.func_177952_p()); ++z) {
                    BlockPos place = new BlockPos(x, y, z);
                    this.blocks.put(place, new PositionStorage(world.func_180495_p(place), world.func_175625_s(place)));
                }
            }
        }
        List tempEntities = world.func_217357_a(Entity.class, new AxisAlignedBB(from, to));
        this.entities.addAll(tempEntities.stream().map(IForgeEntity::serializeNBT).collect(Collectors.toList()));
    }

    public void addPositionStorage(BlockPos place, World world) {
        if (!this.blocks.containsKey(place)) {
            this.blocks.put(place, new PositionStorage(world.func_180495_p(place), world.func_175625_s(place)));
        }
    }

    public void addEntities(List<Entity> list) {
        this.entities.addAll(list.stream().map(IForgeEntity::serializeNBT).collect(Collectors.toList()));
    }

    public void addToBeKilledEntity(Entity entity) {
        this.entitiesToKill.add(entity);
    }

    public boolean undo(World world) {
        int count = 0;
        for (Map.Entry<BlockPos, PositionStorage> entry : new ArrayList<Map.Entry<BlockPos, PositionStorage>>(this.blocks.entrySet())) {
            world.func_175656_a(entry.getKey(), entry.getValue().getState());
            if (entry.getValue().getEntity() != null) {
                world.func_175690_a(entry.getKey(), entry.getValue().getEntity());
            }
            this.blocks.remove(entry.getKey());
            if (++count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
            return false;
        }
        for (CompoundNBT data : this.entities) {
            Entity entity;
            Optional type = EntityType.func_220347_a((CompoundNBT)data);
            if (!type.isPresent() || (entity = ((EntityType)type.get()).func_200721_a(world)) == null) continue;
            entity.deserializeNBT(data);
            world.func_217376_c(entity);
        }
        this.entitiesToKill.forEach(Entity::func_70106_y);
        return true;
    }

    public boolean isOwner(PlayerEntity player) {
        return this.player.func_110124_au().equals(player.func_110124_au());
    }
}

