/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.vector.Vector3d;

public final class StructureUtils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private StructureUtils() {
    }

    public static String calculateMD5(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return StructureUtils.bytesToHex(md.digest(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            Log.getLogger().trace((Object)e);
            return null;
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] compress(byte[] data) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(data.length);
        try (GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
            zipStream.write(data);
        }
        catch (IOException e) {
            Log.getLogger().error("Could not compress the data", (Throwable)e);
        }
        return byteStream.toByteArray();
    }

    public static byte[] uncompress(byte[] data) {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
             GZIPInputStream zipStream = new GZIPInputStream(byteStream);){
            int len;
            while ((len = zipStream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            Log.getLogger().warn("Could not uncompress data", (Throwable)e);
        }
        return out.toByteArray();
    }

    public static String calculateMD5(InputStream stream) {
        if (stream == null) {
            Log.getLogger().error("Structure.calculateMD5: stream is null, this should not happen");
            return null;
        }
        return StructureUtils.calculateMD5(StructureLoadingUtils.getStreamAsByteArray(stream));
    }

    public static Vector3d transformedVector3d(PlacementSettings settings, Vector3d vec) {
        Mirror mirrorIn = settings.getMirror();
        Rotation rotationIn = settings.getRotation();
        double xCoord = vec.field_72450_a;
        double yCoord = vec.field_72448_b;
        double zCoord = vec.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                zCoord = 1.0 - zCoord;
                break;
            }
            case FRONT_BACK: {
                xCoord = 1.0 - xCoord;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vector3d(zCoord, yCoord, 1.0 - xCoord);
            }
            case CLOCKWISE_90: {
                return new Vector3d(1.0 - zCoord, yCoord, xCoord);
            }
            case CLOCKWISE_180: {
                return new Vector3d(1.0 - xCoord, yCoord, 1.0 - zCoord);
            }
        }
        return flag ? new Vector3d(xCoord, yCoord, zCoord) : vec;
    }
}

