/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.BlueprintIterator;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import com.ldtteam.structurize.util.ChangeStorage;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.Nullable;

public class TickedWorldOperation {
    private final OperationType operation;
    private BlockPos startPos;
    private BlockPos currentPos;
    private final BlockPos endPos;
    @Nullable
    private final PlayerEntity player;
    private final ChangeStorage storage;
    private final ItemStack firstBlock;
    private final ItemStack secondBlock;
    private final StructurePlacer placer;
    private int structurePhase = 0;

    public TickedWorldOperation(OperationType type, BlockPos startPos, BlockPos endPos, @Nullable PlayerEntity player, ItemStack firstBlock, ItemStack secondBlock) {
        this.operation = type;
        this.startPos = new BlockPos(Math.min(startPos.func_177958_n(), endPos.func_177958_n()), Math.min(startPos.func_177956_o(), endPos.func_177956_o()), Math.min(startPos.func_177952_p(), endPos.func_177952_p()));
        this.currentPos = new BlockPos(Math.min(startPos.func_177958_n(), endPos.func_177958_n()), Math.min(startPos.func_177956_o(), endPos.func_177956_o()), Math.min(startPos.func_177952_p(), endPos.func_177952_p()));
        this.endPos = new BlockPos(Math.max(startPos.func_177958_n(), endPos.func_177958_n()), Math.max(startPos.func_177956_o(), endPos.func_177956_o()), Math.max(startPos.func_177952_p(), endPos.func_177952_p()));
        this.player = player;
        this.firstBlock = firstBlock;
        this.secondBlock = secondBlock;
        this.storage = new ChangeStorage(player);
        this.placer = null;
    }

    public TickedWorldOperation(ChangeStorage storage, @Nullable PlayerEntity player) {
        this.operation = OperationType.UNDO;
        this.startPos = BlockPos.field_177992_a;
        this.currentPos = BlockPos.field_177992_a;
        this.endPos = BlockPos.field_177992_a;
        this.player = player;
        this.firstBlock = ItemStack.field_190927_a;
        this.secondBlock = ItemStack.field_190927_a;
        this.storage = storage;
        this.placer = null;
    }

    public TickedWorldOperation(StructurePlacer placer, @Nullable PlayerEntity player) {
        this.operation = OperationType.PLACE_STRUCTURE;
        this.startPos = BlockPos.field_177992_a;
        this.currentPos = BlueprintIterator.NULL_POS;
        this.endPos = BlockPos.field_177992_a;
        this.player = player;
        this.firstBlock = ItemStack.field_190927_a;
        this.secondBlock = ItemStack.field_190927_a;
        this.storage = new ChangeStorage(player);
        this.placer = placer;
    }

    public boolean apply(ServerWorld world) {
        if (this.player != null && this.player.field_70170_p.func_234923_W_() != world.func_234923_W_()) {
            return false;
        }
        if (this.operation == OperationType.UNDO) {
            return this.storage.undo((World)world);
        }
        if (this.operation == OperationType.PLACE_STRUCTURE) {
            if (this.placer.getHandler().getWorld().func_234923_W_().func_240901_a_().equals((Object)world.func_234923_W_().func_240901_a_())) {
                StructurePhasePlacementResult result;
                switch (this.structurePhase) {
                    case 0: {
                        result = this.placer.executeStructureStep((World)world, this.storage, this.currentPos, StructurePlacer.Operation.WATER_REMOVAL, () -> this.placer.getIterator().decrement((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> info.getBlockInfo().getState().func_200132_m())), false);
                        this.currentPos = result.getIteratorPos();
                        break;
                    }
                    case 1: {
                        result = this.placer.executeStructureStep((World)world, this.storage, this.currentPos, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> this.placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> !info.getBlockInfo().getState().func_185904_a().func_76220_a())), false);
                        this.currentPos = result.getIteratorPos();
                        break;
                    }
                    case 2: {
                        result = this.placer.executeStructureStep((World)world, this.storage, this.currentPos, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> this.placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> info.getBlockInfo().getState().func_185904_a().func_76220_a())), false);
                        this.currentPos = result.getIteratorPos();
                        break;
                    }
                    default: {
                        result = this.placer.executeStructureStep((World)world, this.storage, this.currentPos, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> this.placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> info.getEntities().length == 0)), true);
                        this.structurePhase = -1;
                        this.currentPos = null;
                    }
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    ++this.structurePhase;
                }
                return this.currentPos == null;
            }
            return false;
        }
        return this.run(world);
    }

    private boolean run(ServerWorld world) {
        FakePlayer fakePlayer = new FakePlayer(world, new GameProfile(this.player == null ? UUID.randomUUID() : this.player.func_110124_au(), "placeStuffForMePl0x"));
        int count = 0;
        for (int y = this.currentPos.func_177956_o(); y <= this.endPos.func_177956_o(); ++y) {
            for (int x = this.currentPos.func_177958_n(); x <= this.endPos.func_177958_n(); ++x) {
                for (int z = this.currentPos.func_177952_p(); z <= this.endPos.func_177952_p(); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    BlockState blockState = world.func_180495_p(here);
                    ItemStack stack = BlockUtils.getItemStackFromBlockState(blockState);
                    if (!TickedWorldOperation.correctBlockToRemoveOrReplace(stack, blockState, this.firstBlock) || blockState.func_177230_c() instanceof DoorBlock && blockState.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER || blockState.func_177230_c() instanceof BedBlock && blockState.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.HEAD) continue;
                    ++count;
                    this.storage.addPositionStorage(here, (World)world);
                    if (blockState.func_177230_c() instanceof IBucketPickupHandler || blockState.func_177230_c() instanceof FlowingFluidBlock) {
                        BlockUtils.removeFluid((World)world, here);
                        if (this.firstBlock.func_77973_b() instanceof BucketItem && !(blockState.func_177230_c() instanceof FlowingFluidBlock)) {
                            if (count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
                            this.currentPos = new BlockPos(x, y, z);
                            return false;
                        }
                    }
                    if (this.operation == OperationType.REPLACE_BLOCK) {
                        BlockUtils.handleCorrectBlockPlacement((World)world, fakePlayer, this.secondBlock, blockState, here);
                    } else {
                        world.func_217377_a(here, false);
                    }
                    if (count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
                    this.currentPos = new BlockPos(x, y, z);
                    return false;
                }
                this.currentPos = new BlockPos(x, y, this.startPos.func_177952_p());
            }
            this.currentPos = new BlockPos(this.startPos.func_177958_n(), y, this.startPos.func_177952_p());
        }
        return true;
    }

    private static boolean correctBlockToRemoveOrReplace(ItemStack replacementStack, BlockState worldState, ItemStack compareStack) {
        return replacementStack != null && replacementStack.func_77969_a(compareStack) || compareStack.func_77973_b() instanceof BucketItem && ((BucketItem)compareStack.func_77973_b()).getFluid() == worldState.func_204520_s().func_206886_c() || compareStack.func_77973_b() instanceof BucketItem && worldState.func_177230_c() instanceof FlowingFluidBlock && ((BucketItem)compareStack.func_77973_b()).getFluid() == ((FlowingFluidBlock)worldState.func_177230_c()).getFluid() || compareStack.func_77973_b() == Items.field_190931_a && worldState.func_177230_c() == Blocks.field_150350_a;
    }

    public ChangeStorage getChangeStorage() {
        return this.storage;
    }

    public boolean isUndo() {
        return this.operation == OperationType.UNDO;
    }

    public static enum OperationType {
        REMOVE_BLOCK,
        REPLACE_BLOCK,
        REMOVE_ENTITY,
        SCAN,
        PLACE_STRUCTURE,
        UNDO;

    }
}

