/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.InMemoryFormat;
import it.unimi.dsi.fastutil.ints.Int2DoubleArrayMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigManager {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Int2DoubleMap axeLevelMap;

    public static double getAxeLevelMultiplier(int axeLevel) {
        if (axeLevelMap.containsKey(axeLevel)) {
            return axeLevelMap.get(axeLevel);
        }
        double value = 1 + axeLevel;
        axeLevelMap.put(axeLevel, value);
        return value;
    }

    public static boolean getConfigBoolean(String categoryName, String keyName) {
        ForgeConfigSpec.BooleanValue value = (ForgeConfigSpec.BooleanValue)SERVER_SPEC.getValues().get(Arrays.asList(categoryName, keyName));
        return (Boolean)value.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        axeLevelMap = new Int2DoubleArrayMap();
    }

    @Mod.EventBusSubscriber(modid="survivalist", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Events {
        private static final Pattern AXE_LEVEL_ENTRY_PATTERN = Pattern.compile("^AxeLevel(?<level>[0-9]+)$");

        @SubscribeEvent
        public static void modConfig(ModConfig.ModConfigEvent event) {
            ModConfig config = event.getConfig();
            if (config.getSpec() != SERVER_SPEC) {
                return;
            }
            Config axeLevels = (Config)ConfigManager.SERVER.axeLevels.get();
            for (Config.Entry e : axeLevels.entrySet()) {
                Matcher m = AXE_LEVEL_ENTRY_PATTERN.matcher(e.getKey());
                if (!m.matches()) continue;
                String numberPart = m.group("level");
                int levelNumber = Integer.parseInt(numberPart);
                axeLevelMap.put(levelNumber, (double)e.getIntOrElse(1 + levelNumber));
            }
        }
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.BooleanValue removeSticksFromPlanks;
        public final ForgeConfigSpec.BooleanValue enableRocks;
        public final ForgeConfigSpec.BooleanValue replaceStoneDrops;
        public final ForgeConfigSpec.BooleanValue replaceIronOreDrops;
        public final ForgeConfigSpec.BooleanValue replaceGoldOreDrops;
        public final ForgeConfigSpec.BooleanValue replaceModOreDrops;
        public final ForgeConfigSpec.BooleanValue replacePoorOreDrops;
        public final ForgeConfigSpec.BooleanValue cobbleRequiresClay;
        public final ForgeConfigSpec.BooleanValue enableScraping;
        public final ForgeConfigSpec.BooleanValue scrapingIsTreasure;
        public final ForgeConfigSpec.BooleanValue enableToolScraping;
        public final ForgeConfigSpec.BooleanValue enableArmorScraping;
        public final ForgeConfigSpec.BooleanValue enableMeatRotting;
        public final ForgeConfigSpec.BooleanValue enableRottenDrying;
        public final ForgeConfigSpec.BooleanValue enableJerky;
        public final ForgeConfigSpec.BooleanValue enableMeatDrying;
        public final ForgeConfigSpec.BooleanValue enableLeatherTanning;
        public final ForgeConfigSpec.BooleanValue enableSaddleCrafting;
        public final ForgeConfigSpec.BooleanValue enableTorchFire;
        public final ForgeConfigSpec.BooleanValue enableBread;
        public final ForgeConfigSpec.BooleanValue removeVanillaBread;
        public final ForgeConfigSpec.BooleanValue disablePlanksRecipes;
        public final ForgeConfigSpec.DoubleValue choppingDegradeChance;
        public final ForgeConfigSpec.DoubleValue choppingExhaustion;
        public final ForgeConfigSpec.DoubleValue choppingWithEmptyHand;
        public final ForgeConfigSpec.BooleanValue dropStringFromSheep;
        public final ForgeConfigSpec.BooleanValue enableStringCrafting;
        public final ForgeConfigSpec.BooleanValue mergeSlimes;
        public final ForgeConfigSpec.ConfigValue<Config> axeLevels;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for stick crafting").push("sticks");
            this.removeSticksFromPlanks = builder.define("RemoveSticksFromPlanksRecipes", true);
            builder.pop();
            builder.comment("Settings for rock and ore rock drops").push("rocks");
            this.enableRocks = builder.define("Enable", true);
            this.replaceStoneDrops = builder.define("ReplaceStoneDrops", true);
            this.replaceIronOreDrops = builder.define("ReplaceIronOreDrops", true);
            this.replaceGoldOreDrops = builder.define("ReplaceGoldOreDrops", true);
            this.replaceModOreDrops = builder.define("ReplaceModOreDrops", true);
            this.replacePoorOreDrops = builder.define("ReplacePoorOreDrops", true);
            this.cobbleRequiresClay = builder.define("CobbleRequiresClay", true);
            builder.pop();
            builder.comment("Settings for the Scraping feature and enchant").push("scraping");
            this.enableScraping = builder.define("Enable", false);
            this.scrapingIsTreasure = builder.define("IsTreasureEnchantment", false);
            this.enableToolScraping = builder.define("EnableToolScraping", true);
            this.enableArmorScraping = builder.define("EnableArmorScraping", true);
            builder.pop();
            builder.comment("Settings for the drying rack block").push("drying_rack");
            this.enableMeatRotting = builder.define("EnableMeatRotting", true);
            this.enableRottenDrying = builder.define("EnableRottenDrying", true);
            this.enableJerky = builder.define("EnableJerky", true);
            this.enableMeatDrying = builder.define("EnableMeatDrying", true);
            this.enableLeatherTanning = builder.define("EnableLeatherTanning", true);
            this.enableSaddleCrafting = builder.define("EnableSaddleCrafting", true);
            builder.pop();
            builder.comment("Settings for the torch setting fire to entities").push("torch_fire");
            this.enableTorchFire = builder.define("Enable", true);
            builder.pop();
            builder.comment("Settings for the dough/bread replacements").push("bread");
            this.enableBread = builder.define("Enable", true);
            this.removeVanillaBread = builder.define("RemoveVanillaBread", true);
            builder.pop();
            builder.comment("Settings for the chopping block").push("chopping");
            this.disablePlanksRecipes = builder.define("DisablePlanksRecipes", true);
            this.choppingDegradeChance = builder.comment("The average number of uses before degrading to the next phase will be 1/DegradeChance. Default is 16.67 average uses.").defineInRange("DegradeChance", 0.06, 0.0, Double.MAX_VALUE);
            this.choppingExhaustion = builder.defineInRange("Exhaustion", 0.0025, 0.0, Double.MAX_VALUE);
            this.choppingWithEmptyHand = builder.defineInRange("EmptyHandFactor", 0.4, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.comment("Settings for the fibre collection").push("fibres");
            this.dropStringFromSheep = builder.define("DropStringFromSheep", true);
            this.enableStringCrafting = builder.define("EnableStringCrafting", true);
            builder.pop();
            builder.comment("Settings for slime merging").push("slimes");
            this.mergeSlimes = builder.comment("If enabled, slimes will have new AI rules to feel attracted to other slimes, and if 4 slimes of the same size are nearby they will merge into a slime of higher size.").define("Merge", true);
            builder.pop();
            this.axeLevels = builder.comment("If enabled, slimes will have new AI rules to feel attracted to other slimes, and if 4 slimes of the same size are nearby they will merge into a slime of higher size.").define(Arrays.asList("axe_levels"), () -> Config.of((ConfigFormat)InMemoryFormat.defaultInstance()), x -> true, Config.class);
        }

        private class AxeMap {
            private AxeMap() {
            }
        }
    }
}

