/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gigaherz.survivalist.ConfigToggledIngredientSerializer;
import gigaherz.survivalist.ConfigurationCondition;
import gigaherz.survivalist.SurvivalistBlocks;
import gigaherz.survivalist.SurvivalistItems;
import gigaherz.survivalist.SurvivalistMod;
import gigaherz.survivalist.chopblock.ChopblockMaterials;
import gigaherz.survivalist.chopblock.ChoppingBlock;
import gigaherz.survivalist.rocks.Nuggets;
import gigaherz.survivalist.rocks.Rocks;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SurvivalistData {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            // empty if block
        }
        if (event.includeServer()) {
            BlockTags blockTags = new BlockTags(gen);
            gen.func_200390_a((IDataProvider)blockTags);
            gen.func_200390_a((IDataProvider)new ItemTags(gen, blockTags));
            gen.func_200390_a((IDataProvider)new Recipes(gen));
            gen.func_200390_a((IDataProvider)new LootTables(gen));
        }
    }

    public static ITag.INamedTag<Item> makeItemTag(String id) {
        return SurvivalistData.makeItemTag(new ResourceLocation(id));
    }

    public static ITag.INamedTag<Item> makeItemTag(ResourceLocation id) {
        return net.minecraft.tags.ItemTags.func_199901_a((String)id.toString());
    }

    private static class LootTables
    extends LootTableProvider
    implements IDataProvider {
        private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(BlockTables::new, (Object)LootParameterSets.field_216267_h));

        public LootTables(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return this.tables;
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
            map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
        }

        public static class BlockTables
        extends BlockLootTables {
            protected void addTables() {
                this.func_218492_c((Block)SurvivalistBlocks.RACK.get());
                this.func_218492_c((Block)SurvivalistBlocks.SAWMILL.get());
                this.func_218492_c((Block)SurvivalistBlocks.OAK_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.CHIPPED_OAK_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.DAMAGED_OAK_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.BIRCH_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.CHIPPED_BIRCH_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.DAMAGED_BIRCH_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.SPRUCE_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.CHIPPED_SPRUCE_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.DAMAGED_SPRUCE_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.JUNGLE_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.CHIPPED_JUNGLE_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.DAMAGED_JUNGLE_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.DARK_OAK_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.CHIPPED_DARK_OAK_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.DAMAGED_DARK_OAK_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.ACACIA_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.CHIPPED_ACACIA_CHOPPING_BLOCK.get());
                this.func_218492_c((Block)SurvivalistBlocks.DAMAGED_ACACIA_CHOPPING_BLOCK.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().func_110624_b().equals("survivalist")).collect(Collectors.toList());
            }
        }
    }

    private static class BlockTags
    extends BlockTagsProvider
    implements IDataProvider {
        public BlockTags(DataGenerator gen) {
            super(gen);
        }

        protected void func_200432_c() {
            this.func_240522_a_(net.minecraft.tags.BlockTags.func_199894_a((String)SurvivalistMod.location("chopping_blocks").toString())).func_240534_a_((Object[])Arrays.stream(ChopblockMaterials.values()).flatMap(block -> Stream.of(block.getPristine(), block.getChipped(), block.getDamaged()).map(Supplier::get)).toArray(Block[]::new));
        }
    }

    private static class ItemTags
    extends ItemTagsProvider
    implements IDataProvider {
        public ItemTags(DataGenerator gen, BlockTags blockTags) {
            super(gen, (BlockTagsProvider)blockTags);
        }

        protected void func_200432_c() {
            Arrays.stream(Rocks.values()).forEach(rock -> {
                rock.getTagLocations().stream().map(tag -> Pair.of((Object)rock.getItem().get(), (Object)tag)).forEach(pair -> this.func_240522_a_(SurvivalistData.makeItemTag((ResourceLocation)pair.getSecond())).func_240534_a_((Object[])new Item[]{(Item)pair.getFirst()}));
                if (rock.isOre()) {
                    // empty if block
                }
            });
            Arrays.stream(Nuggets.values()).flatMap(rock -> rock.getTagLocations().stream().map(tag -> Pair.of((Object)rock.getItem().get(), (Object)tag))).forEach(pair -> this.func_240522_a_(SurvivalistData.makeItemTag((ResourceLocation)pair.getSecond())).func_240534_a_((Object[])new Item[]{(Item)pair.getFirst()}));
            this.func_240522_a_(SurvivalistData.makeItemTag(SurvivalistMod.location("dough"))).func_240534_a_((Object[])new Item[]{(Item)SurvivalistItems.DOUGH.get()});
            this.func_240522_a_(SurvivalistData.makeItemTag(SurvivalistMod.location("chopping_blocks"))).func_240534_a_((Object[])Arrays.stream(ChopblockMaterials.values()).flatMap(block -> Stream.of(block.getPristine(), block.getChipped(), block.getDamaged()).map(reg -> ((ChoppingBlock)reg.get()).func_199767_j())).toArray(Item[]::new));
        }
    }

    private static class Recipes
    extends RecipeProvider
    implements IDataProvider,
    IConditionBuilder {
        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
            Arrays.stream(ChopblockMaterials.values()).forEach(rock -> {
                ITag.INamedTag<Item> tag = SurvivalistData.makeItemTag(rock.getMadeFrom());
                RegistryObject<ChoppingBlock> result = rock.getPristine();
                ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)result.get())).func_203221_a(tag).func_200483_a("has_rock", (ICriterionInstance)Recipes.func_200409_a(tag)).func_200482_a(consumer);
            });
            Arrays.stream(Rocks.values()).forEach(rock -> rock.getCraftsInto().ifPresent(result -> {
                RegistryObject<? extends Item> rockItem = rock.getItem();
                ResourceLocation itemId = rockItem.getId();
                if (rock.isOre()) {
                    ITag.INamedTag<Item> tag = SurvivalistData.makeItemTag(rock.getSmeltingTag());
                    CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(tag), (IItemProvider)((IItemProvider)result.get()), (float)0.2f, (int)50).func_218628_a("has_rock", (ICriterionInstance)Recipes.func_200409_a(tag)).func_218635_a(consumer, new ResourceLocation(itemId.func_110624_b(), "smelting/" + itemId.func_110623_a()));
                    CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199805_a(tag), (IItemProvider)((IItemProvider)result.get()), (float)0.2f, (int)25).func_218628_a("has_rock", (ICriterionInstance)Recipes.func_200409_a(tag)).func_218635_a(consumer, new ResourceLocation(itemId.func_110624_b(), "smelting/" + itemId.func_110623_a() + "_from_blasting"));
                } else {
                    ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("rrr").func_200472_a("rcr").func_200472_a("rrr").func_200462_a(Character.valueOf('r'), (IItemProvider)rockItem.get()).func_200471_a(Character.valueOf('c'), (Ingredient)new ConfigToggledIngredientSerializer.ConfigToggledIngredient("rocks", "CobbleRequiresClay", Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151119_aD}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)rockItem.get()}))).func_200465_a("has_rock", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)((IItemProvider)result.get()))).func_200467_a(consumer, new ResourceLocation("survivalist", ((Item)result.get()).getRegistryName().func_110623_a() + "_from_rocks"));
                }
            }));
            ITag.INamedTag<Item> dough = SurvivalistData.makeItemTag(SurvivalistMod.location("dough"));
            CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(dough), (IItemProvider)((IItemProvider)SurvivalistItems.ROUND_BREAD.get()), (float)0.45f, (int)300).func_218628_a("has_dough", (ICriterionInstance)Recipes.func_200409_a(dough)).func_218635_a(consumer, SurvivalistMod.location("cooking/round_bread"));
            CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199805_a(dough), (IItemProvider)((IItemProvider)SurvivalistItems.ROUND_BREAD.get()), (float)0.45f, (int)150, (CookingRecipeSerializer)IRecipeSerializer.field_222173_q).func_218628_a("has_dough", (ICriterionInstance)Recipes.func_200409_a(dough)).func_218635_a(consumer, SurvivalistMod.location("cooking/round_bread_from_smoking"));
            ITag.INamedTag<Item> leatherTag = SurvivalistData.makeItemTag("survivalist:tanned_leather");
            ResourceLocation saddleRecipeId = SurvivalistMod.location("saddle");
            ConditionalRecipe.builder().addCondition((ICondition)new ConfigurationCondition("drying_rack", "EnableSaddleCrafting")).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151141_av, (int)1).func_200472_a("ttt").func_200472_a("tst").func_200472_a("i i").func_200469_a(Character.valueOf('t'), leatherTag).func_200462_a(Character.valueOf('s'), (IItemProvider)Items.field_151007_F).func_200462_a(Character.valueOf('i'), (IItemProvider)Items.field_151042_j).func_200473_b("").func_200465_a("has_leather", (ICriterionInstance)Recipes.func_200409_a(leatherTag))).func_200464_a(arg_0)).setAdvancement(SurvivalistMod.location("craft_saddle"), ConditionalAdvancement.builder().addCondition((ICondition)new ConfigurationCondition("drying_rack", "EnableSaddleCrafting")).addAdvancement(Advancement.Builder.func_200278_a().func_200272_a(new ResourceLocation("minecraft", "recipes/root")).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)saddleRecipeId)).func_200270_a(IRequirementsStrategy.field_223215_b_).func_200275_a("has_leather", (ICriterionInstance)Recipes.func_200409_a(leatherTag)).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)saddleRecipeId)))).build(consumer, saddleRecipeId);
        }
    }
}

