/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.chopblock;

import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.api.ChoppingRecipe;
import gigaherz.survivalist.chopblock.ChoppingBlockTileEntity;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="survivalist")
public class ChoppingBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private final Supplier<BlockState> breaksInto;

    public ChoppingBlock(@Nullable Supplier<BlockState> breaksInto, AbstractBlock.Properties properties) {
        super(properties);
        this.breaksInto = breaksInto != null ? breaksInto : () -> Blocks.field_150350_a.func_176223_P();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ChoppingBlockTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return heldItem.func_190916_E() <= 0 || ChoppingRecipe.getRecipe(worldIn, heldItem).isPresent() ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof ChoppingBlockTileEntity) || player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        ChoppingBlockTileEntity chopper = (ChoppingBlockTileEntity)tileEntity;
        if (heldItem.func_190916_E() <= 0) {
            ItemStack extracted = chopper.getSlotInventory().extractItem(0, 1, false);
            if (extracted.func_190916_E() > 0) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)extracted);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (ChoppingRecipe.getRecipe(worldIn, heldItem).isPresent()) {
            ItemStack remaining = chopper.getSlotInventory().insertItem(0, heldItem, false);
            if (!player.func_184812_l_()) {
                if (remaining.func_190916_E() > 0) {
                    player.func_184611_a(hand, remaining);
                } else {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
            }
            return remaining.func_190916_E() < heldItem.func_190916_E() ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    @SubscribeEvent
    public static void interactEvent(PlayerInteractEvent.LeftClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof ChoppingBlock && ((ChoppingBlock)block).interceptClick(world, pos, state, player)) {
            event.setCanceled(true);
        }
    }

    private boolean interceptClick(World worldIn, BlockPos pos, BlockState state, PlayerEntity playerIn) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof ChoppingBlockTileEntity)) {
            return false;
        }
        ChoppingBlockTileEntity chopper = (ChoppingBlockTileEntity)tileentity;
        if (chopper.getSlotInventory().getStackInSlot(0).func_190916_E() <= 0) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack heldItem = playerIn.func_184586_b(Hand.MAIN_HAND);
        int harvestLevel = heldItem.func_77973_b().getHarvestLevel(heldItem, ToolType.AXE, playerIn, null);
        ActionResult<ItemStack> result = chopper.chop(playerIn, harvestLevel, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem));
        if (result.func_188397_a() == ActionResultType.SUCCESS) {
            if ((double)worldIn.field_73012_v.nextFloat() < (Double)ConfigManager.SERVER.choppingDegradeChance.get()) {
                worldIn.func_175656_a(pos, this.breaksInto.get());
            }
            if ((Double)ConfigManager.SERVER.choppingExhaustion.get() > 0.0) {
                playerIn.func_71020_j(((Double)ConfigManager.SERVER.choppingExhaustion.get()).floatValue());
            }
            if (heldItem.func_190916_E() > 0 && !playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_222118_a(1, (LivingEntity)playerIn, stack -> stack.func_213334_d(Hand.MAIN_HAND));
            }
        }
        if (result.func_188397_a() != ActionResultType.PASS) {
            ((ServerWorld)worldIn).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, (ItemStack)result.func_188398_b()), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.6, (double)pos.func_177952_p() + 0.5, 8, 0.0, 0.1, 0.0, 0.02);
        }
        return true;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != state.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof ChoppingBlockTileEntity) {
                ChoppingBlock.dropInventoryItems(worldIn, pos, (IItemHandler)((ChoppingBlockTileEntity)tileentity).getSlotInventory());
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190916_E() <= 0) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
    }
}

