/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.chopblock;

import gigaherz.survivalist.SurvivalistTileEntityTypes;
import gigaherz.survivalist.api.ChoppingContext;
import gigaherz.survivalist.api.ChoppingRecipe;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ChoppingBlockTileEntity
extends TileEntity {
    public static final RegistryObject<TileEntityType<ChoppingBlockTileEntity>> TYPE = SurvivalistTileEntityTypes.CHOPPING_BLOCK_TILE_ENTITY_TYPE;
    private static final Random RANDOM = new Random();
    private final ItemStackHandler slotInventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!ChoppingRecipe.getRecipe(ChoppingBlockTileEntity.this.field_145850_b, stack).isPresent()) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            ChoppingBlockTileEntity.this.breakingProgress = 0;
            if (ChoppingBlockTileEntity.this.field_145850_b != null) {
                BlockState state = ChoppingBlockTileEntity.this.field_145850_b.func_180495_p(ChoppingBlockTileEntity.this.field_174879_c);
                ChoppingBlockTileEntity.this.field_145850_b.func_184138_a(ChoppingBlockTileEntity.this.field_174879_c, state, state, 3);
            }
            ChoppingBlockTileEntity.this.func_70296_d();
        }
    };
    private final LazyOptional<IItemHandler> slotInventoryGetter = LazyOptional.of(() -> this.slotInventory);
    private int breakingProgress = 0;

    public ChoppingBlockTileEntity() {
        super((TileEntityType)TYPE.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.slotInventoryGetter.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.slotInventory, null, compound.func_74781_a("Inventory"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_218657_a("Inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.slotInventory, null));
        return compound;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Item", (INBT)this.slotInventory.getStackInSlot(0).serializeNBT());
        return compound;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.slotInventory.setStackInSlot(0, ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Item")));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    public ActionResult<ItemStack> chop(PlayerEntity player, int axeLevel, int fortune) {
        ActionResultType completed = ActionResultType.PASS;
        ItemStack containedItem = this.slotInventory.getStackInSlot(0).func_77946_l();
        if (containedItem.func_190916_E() > 0) {
            ChoppingContext ctx = new ChoppingContext((IItemHandlerModifiable)this.slotInventory, player, axeLevel, fortune, RANDOM);
            Optional<ChoppingRecipe> foundRecipe = ChoppingRecipe.getRecipe(this.field_145850_b, ctx);
            completed = foundRecipe.map(recipe -> {
                ActionResultType completed2 = ActionResultType.PASS;
                this.breakingProgress = (int)((double)this.breakingProgress + recipe.getHitProgress(axeLevel));
                if (this.breakingProgress >= 200) {
                    if (!this.field_145850_b.field_72995_K) {
                        ItemStack out = recipe.getCraftingResult(ctx);
                        if (out.func_190916_E() > 0) {
                            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)out);
                            completed2 = ActionResultType.SUCCESS;
                        } else {
                            completed2 = ActionResultType.FAIL;
                        }
                    }
                    this.field_145850_b.func_184133_a(player, this.field_174879_c, SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.slotInventory.setStackInSlot(0, ItemStack.field_190927_a);
                    this.breakingProgress = 0;
                }
                BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                return completed2;
            }).orElse(ActionResultType.PASS);
        }
        return new ActionResult(completed, (Object)containedItem);
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        while (stack.func_190916_E() > 0) {
            int i = 1;
            if (i > stack.func_190916_E()) {
                i = stack.func_190916_E();
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(i);
            stack.func_190917_f(-i);
            Block.func_180635_a((World)worldIn, (BlockPos)new BlockPos(x, y, z), (ItemStack)stack);
        }
    }

    public ItemStackHandler getSlotInventory() {
        return this.slotInventory;
    }

    public int getBreakStage() {
        if (this.breakingProgress <= 0) {
            return -1;
        }
        return this.breakingProgress * 10 / 200;
    }
}

