/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.rocks;

import com.google.common.collect.Lists;
import gigaherz.survivalist.SurvivalistItems;
import gigaherz.survivalist.SurvivalistMod;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public enum Rocks implements IStringSerializable
{
    STONE("stone", false, SurvivalistItems.STONE_ROCK, () -> Items.field_221585_m),
    ANDESITE("andesite", false, SurvivalistItems.ANDESITE_ROCK, () -> Items.field_221579_g),
    DIORITE("diorite", false, SurvivalistItems.DIORITE_ROCK, () -> Items.field_221577_e),
    GRANITE("granite", false, SurvivalistItems.GRANITE_ROCK, () -> Items.field_221575_c),
    IRON("iron", true, SurvivalistItems.IRON_ORE_ROCK, () -> Items.field_191525_da),
    GOLD("gold", true, SurvivalistItems.GOLD_ORE_ROCK, () -> Items.field_151074_bl),
    COPPER("copper", true, (RegistryObject<? extends Item>)SurvivalistItems.COPPER_ORE_ROCK, (Supplier<? extends Item>)SurvivalistItems.COPPER_NUGGET),
    TIN("tin", true, (RegistryObject<? extends Item>)SurvivalistItems.TIN_ORE_ROCK, (Supplier<? extends Item>)SurvivalistItems.TIN_NUGGET),
    LEAD("lead", true, (RegistryObject<? extends Item>)SurvivalistItems.LEAD_ORE_ROCK, (Supplier<? extends Item>)SurvivalistItems.LEAD_NUGGET),
    SILVER("silver", true, (RegistryObject<? extends Item>)SurvivalistItems.SILVER_ORE_ROCK, (Supplier<? extends Item>)SurvivalistItems.SILVER_NUGGET),
    ALUMINUM("aluminum", true, (RegistryObject<? extends Item>)SurvivalistItems.ALUMINUM_ORE_ROCK, (Supplier<? extends Item>)SurvivalistItems.ALUMINUM_NUGGET);

    private final String name;
    private final boolean isOre;
    private final RegistryObject<? extends Item> item;
    @Nullable
    private final Supplier<? extends Item> smeltsInto;

    private Rocks(String name, boolean isOre, RegistryObject<? extends Item> item) {
        this.name = name;
        this.isOre = isOre;
        this.item = item;
        this.smeltsInto = null;
    }

    private Rocks(String name, boolean isOre, RegistryObject<? extends Item> item, Supplier<? extends Item> smeltsInto) {
        this.name = name;
        this.isOre = isOre;
        this.item = item;
        this.smeltsInto = smeltsInto;
    }

    public String func_176610_l() {
        return this.name;
    }

    public boolean isOre() {
        return this.isOre;
    }

    public RegistryObject<? extends Item> getItem() {
        return this.item;
    }

    public Optional<Supplier<? extends Item>> getCraftsInto() {
        return Optional.ofNullable(this.smeltsInto);
    }

    public List<ResourceLocation> getTagLocations() {
        if (this.isOre) {
            return Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("forge", "small_ores/" + this.name), new ResourceLocation("forge", "weak_ores/" + this.name), new ResourceLocation("forge", "poor_ores/" + this.name), new ResourceLocation("forge", "ore_rocks/" + this.name), SurvivalistMod.location("ore_rocks/" + this.name)});
        }
        return Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("forge", "rocks/" + this.name), SurvivalistMod.location("rocks/" + this.name)});
    }

    public ResourceLocation getSmeltingTag() {
        return SurvivalistMod.location("ore_rocks/" + this.name);
    }
}

